/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.crud;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.spring.annotation.UIScope;
import elemental.json.JsonObject;
import io.devbench.uibuilder.annotations.ControllerBean;
import io.devbench.uibuilder.api.crud.GenericCrudGridInlineEditorControllerBean;
import io.devbench.uibuilder.data.collectionds.CollectionDataSource;
import io.devbench.uibuilder.data.collectionds.datasource.component.AbstractDataSourceComponent;
import io.devbench.uibuilder.data.common.component.AbstractGenericGridInlineEditorControllerBean;
import io.devbench.uibuilder.data.common.datasource.CommonDataSource;
import io.devbench.uibuilder.spring.crud.exception.GenericInlineEditorSaveItemException;
import io.devbench.uibuilder.spring.data.SpringCommonDataSourceProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.PagingAndSortingRepository;

@UIScope
@ControllerBean(value="builtInGenericCrudGridInlineEditorControllerBean")
public class SpringGenericCrudGridInlineEditorControllerBean<TYPE>
extends AbstractGenericGridInlineEditorControllerBean<TYPE>
implements GenericCrudGridInlineEditorControllerBean<TYPE> {
    private static final Logger log = LoggerFactory.getLogger(SpringGenericCrudGridInlineEditorControllerBean.class);
    private final Map<String, String> datasourceByGridIdMap;
    private final SpringCommonDataSourceProvider commonDataSourceProvider;
    private final ApplicationContext applicationContext;

    public SpringGenericCrudGridInlineEditorControllerBean(SpringCommonDataSourceProvider commonDataSourceProvider, ApplicationContext applicationContext) {
        this.commonDataSourceProvider = commonDataSourceProvider;
        this.applicationContext = applicationContext;
        this.datasourceByGridIdMap = new HashMap<String, String>();
    }

    public void registerDataSourceName(@NotNull String gridId, @NotNull String datasourceName) {
        this.datasourceByGridIdMap.put(gridId, datasourceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onInlineItemSave(@NotNull TYPE modifiedItem, @NotNull JsonObject modifiedJsonItem, @Nullable Component component) {
        if (component == null) throw new GenericInlineEditorSaveItemException("Could not save item, component not found");
        component.getElement().callJsFunction("_inlineItemSaved", new Serializable[]{modifiedJsonItem});
        if (this.isItemDatasourceDriven(component)) return;
        String id = (String)component.getId().orElseThrow(() -> new GenericInlineEditorSaveItemException("Cannot save item, component ID not found"));
        String dataSourceName = this.datasourceByGridIdMap.get(id);
        if (dataSourceName == null) throw new GenericInlineEditorSaveItemException("Could not save item, data-source name not found");
        Optional<Class<PagingAndSortingRepository<TYPE, ?>>> foundRepositoryClass = this.findRepositoryClass(dataSourceName);
        if (!foundRepositoryClass.isPresent()) throw new GenericInlineEditorSaveItemException("Could not save item, target datasource not found");
        Class<PagingAndSortingRepository<TYPE, ?>> repositoryClass = foundRepositoryClass.get();
        ObjectProvider repositoryProvider = this.applicationContext.getBeanProvider(repositoryClass);
        PagingAndSortingRepository repository = (PagingAndSortingRepository)repositoryProvider.getIfAvailable();
        if (repository == null) throw new GenericInlineEditorSaveItemException("Could not save item, repository not found");
        repository.save(modifiedItem);
    }

    private Optional<Class<? extends PagingAndSortingRepository<TYPE, ?>>> findRepositoryClass(String dataSourceName) {
        Pair datasourceRepoPair = this.commonDataSourceProvider.getDataSourceRepositories().get(dataSourceName);
        if (datasourceRepoPair != null) {
            return Optional.ofNullable((Class)datasourceRepoPair.getValue());
        }
        return Optional.empty();
    }

    private boolean isItemDatasourceDriven(Component component) {
        if (component instanceof AbstractDataSourceComponent) {
            CommonDataSource dataSource = ((AbstractDataSourceComponent)component).getDataSource();
            return dataSource instanceof CollectionDataSource;
        }
        return false;
    }

    Map<String, String> getDatasourceByGridIdMap() {
        return this.datasourceByGridIdMap;
    }
}

