/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.component;

import com.vaadin.flow.component.Component;
import io.devbench.uibuilder.api.controllerbean.UIComponent;
import io.devbench.uibuilder.core.controllerbean.ControllerBeanManager;
import io.devbench.uibuilder.core.utils.reflection.PropertyMetadata;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class ControllerBeanComponentInjectionBeanFactory
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, field -> {
            boolean accessible;
            block5: {
                Class componentType;
                String componentId;
                block4: {
                    componentId = field.getAnnotation(UIComponent.class).value();
                    accessible = field.isAccessible();
                    field.setAccessible(true);
                    Class<?> fieldType = field.getType();
                    if (ObjectProvider.class.isAssignableFrom(fieldType)) break block4;
                    if (!Provider.class.isAssignableFrom(fieldType)) break block5;
                }
                if ((componentType = (Class)PropertyMetadata.findGenericType((Field)field).filter(Component.class::isAssignableFrom).orElse(null)) != null) {
                    field.set(bean, new ComponentObjectProvider<Component>(() -> this.findComponentById(componentId, componentType)));
                }
            }
            field.setAccessible(accessible);
        }, field -> field.getAnnotation(UIComponent.class) != null);
        return bean;
    }

    private Component findComponentById(@NotNull String componentId, @NotNull Class<? extends Component> componentClass) {
        return ControllerBeanManager.getInstance().getAllCachedComponentInjectionPoint().stream().filter(componentInjectionPoint -> componentId.equals(componentInjectionPoint.getId())).findFirst().map(componentInjectionPoint -> componentInjectionPoint.getValueForType(componentClass)).orElse(null);
    }

    public static class ComponentObjectProvider<C extends Component>
    implements ObjectProvider<C>,
    Provider<C> {
        private final Supplier<C> objectSupplier;

        public ComponentObjectProvider(Supplier<C> objectSupplier) {
            this.objectSupplier = objectSupplier;
        }

        @Nonnull
        public C getObject(Object ... args) throws BeansException {
            return (C)((Component)this.objectSupplier.get());
        }

        public C getIfAvailable() throws BeansException {
            return (C)((Component)this.objectSupplier.get());
        }

        public C getIfUnique() throws BeansException {
            return (C)((Component)this.objectSupplier.get());
        }

        @Nonnull
        public C getObject() throws BeansException {
            return (C)((Component)this.objectSupplier.get());
        }

        public C get() {
            return (C)((Component)this.objectSupplier.get());
        }
    }
}

