/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.singleton;

import io.devbench.uibuilder.api.singleton.ContextAwareSingletonHolder;
import io.devbench.uibuilder.api.singleton.ContextUnawareSingletonHolder;
import io.devbench.uibuilder.api.singleton.SingletonManagerProvider;
import io.devbench.uibuilder.api.singleton.SingletonProvider;
import io.devbench.uibuilder.spring.singleton.SpringSingletonManagerContextHolder;
import io.devbench.uibuilder.spring.singleton.SpringSingletonManagerContextHolderNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SpringSingletonManagerProvider
implements SingletonManagerProvider,
ApplicationContextAware {
    private static SpringSingletonManagerContextHolder contextHolder;

    private Optional<SpringSingletonManagerContextHolder> getContextHolder() {
        return Optional.ofNullable(contextHolder);
    }

    private void setContextHolder(SpringSingletonManagerContextHolder contextHolder) {
        SpringSingletonManagerProvider.contextHolder = contextHolder;
    }

    public Collection<SingletonProvider> getSingletonProviders() {
        return this.getContextHolder().orElseThrow(SpringSingletonManagerContextHolderNotFoundException::new).getSingletonProviders();
    }

    public Collection<ContextAwareSingletonHolder> getContextAwareSingletonHolders() {
        return this.getContextHolder().orElseThrow(SpringSingletonManagerContextHolderNotFoundException::new).getContextAwareSingletonHolders();
    }

    public Collection<ContextUnawareSingletonHolder> getContextUnawareSingletonHolders() {
        return Collections.emptyList();
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.setContextHolder(new SpringSingletonManagerContextHolder(applicationContext));
    }
}

