/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.page;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class PageScopeBeanId {
    private final String beanName;
    private final String pageName;

    private PageScopeBeanId(String beanName, String pageName) {
        this.beanName = Objects.requireNonNull(beanName);
        this.pageName = Objects.requireNonNull(pageName);
    }

    public static PageScopeBeanId of(@NotNull String beanName, @NotNull String pageName) {
        return new PageScopeBeanId(beanName, pageName);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageScopeBeanId that = (PageScopeBeanId)o;
        return this.getBeanName().equals(that.getBeanName()) && this.getPageName().equals(that.getPageName());
    }

    public int hashCode() {
        return Objects.hash(this.getBeanName(), this.getPageName());
    }
}

