/*
 *
 * Copyright © 2018 Webvalto Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.devbench.uibuilder.spring.data;

import io.devbench.uibuilder.data.api.annotations.TargetDataSource;
import io.devbench.uibuilder.data.common.parse.annotation.IdAnnotationParser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface IdHandler {
    default List<String> getKeyPaths(TargetDataSource targetDataSource, Class<?> entityType) {
        if (targetDataSource.keys().length == 0) {
            return new ArrayList<>(IdAnnotationParser.getIdPropertyPathsFromClass(entityType));
        } else {
            return Arrays.asList(targetDataSource.keys());
        }
    }
}
