/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.page;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import io.devbench.uibuilder.spring.page.BeanStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class BeanStoreWrapper
implements ComponentEventListener<DetachEvent> {
    private final VaadinSession vaadinSession;
    private final Map<UI, Map<Class<?>, BeanStore<?>>> beanStores;

    BeanStoreWrapper(VaadinSession vaadinSession) {
        this.vaadinSession = vaadinSession;
        this.beanStores = new HashMap();
    }

    <T> BeanStore<T> getBeanStore(UI ui, Class<T> clazz) {
        this.beanStores.computeIfAbsent(ui, this::createNewMapForUI);
        this.beanStores.get(ui).computeIfAbsent(clazz, aClass -> this.createNewBeanStoreForClazz());
        BeanStore<?> beanStore = this.beanStores.get(ui).get(clazz);
        return beanStore;
    }

    private BeanStore<?> createNewBeanStoreForClazz() {
        return new BeanStore(this.vaadinSession);
    }

    private Map<Class<?>, BeanStore<?>> createNewMapForUI(UI ui) {
        ui.addDetachListener((ComponentEventListener)this);
        return new HashMap();
    }

    public void onComponentEvent(DetachEvent event) {
        Optional.ofNullable(this.beanStores.get(event.getUI())).ifPresent(beanStoresForClasses -> {
            beanStoresForClasses.values().forEach(beanStore -> beanStore.destroyBeans(bean -> true));
            beanStoresForClasses.clear();
        });
    }
}

