/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.page;

import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectFactory;

class BeanStore<BEAN_ID>
implements Serializable {
    private final VaadinSession vaadinSession;
    private final Map<BEAN_ID, List<Runnable>> destructionCallbacks;
    private final Map<BEAN_ID, Object> beans;

    BeanStore(VaadinSession vaadinSession) {
        this.vaadinSession = vaadinSession;
        this.beans = new ConcurrentHashMap<BEAN_ID, Object>();
        this.destructionCallbacks = new HashMap<BEAN_ID, List<Runnable>>();
    }

    public Object get(BEAN_ID beanId, ObjectFactory<?> objectFactory) {
        return this.inLock(() -> {
            this.beans.computeIfAbsent(beanId, id -> objectFactory.getObject());
            return this.beans.get(beanId);
        });
    }

    private <T> T inLock(Supplier<T> supplier) {
        if (this.vaadinSession.hasLock()) {
            return supplier.get();
        }
        try {
            this.vaadinSession.lock();
            T t = supplier.get();
            return t;
        }
        finally {
            this.vaadinSession.unlock();
        }
    }

    public void destroyBeans(Predicate<BEAN_ID> predicate) {
        this.inLock(() -> {
            List<Object> toRemoveKeys = this.beans.keySet().stream().filter(predicate).collect(Collectors.toList());
            toRemoveKeys.forEach(beanId -> {
                this.destructionCallbacks.getOrDefault(beanId, Collections.emptyList()).forEach(Runnable::run);
                this.destructionCallbacks.remove(beanId);
            });
            toRemoveKeys.forEach(this.beans::remove);
            return null;
        });
    }

    public void registerDestructionCallback(BEAN_ID beanIdForBean, Runnable callback) {
        this.inLock(() -> {
            this.destructionCallbacks.computeIfAbsent(beanIdForBean, id -> new ArrayList());
            this.destructionCallbacks.get(beanIdForBean).add(callback);
            return null;
        });
    }
}

