/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.applicationcontext;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class AppCtx
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AppCtx.class);
    private static ApplicationContext context = null;

    @Nullable
    public static <T> T bean(Class<T> clazz) {
        try {
            return (T)context.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static <T> T bean(String name, Class<T> clazz) {
        return (T)context.getBean(name, clazz);
    }

    @Nullable
    public static Object bean(String name) {
        try {
            return context.getBean(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean containsBean(String beanName) {
        return context.containsBean(beanName);
    }

    public static void registerBean(String name, Class clazz, BeanDefinitionCustomizer ... beanDefinitionCustomizers) {
        ((GenericApplicationContext)context).registerBean(name, clazz, beanDefinitionCustomizers);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static void remove(String beanName) {
        AutowireCapableBeanFactory autowireCapableBeanFactory = context.getAutowireCapableBeanFactory();
        if (autowireCapableBeanFactory instanceof BeanDefinitionRegistry) {
            ((BeanDefinitionRegistry)autowireCapableBeanFactory).removeBeanDefinition(beanName);
        }
    }
}

