/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.spring.SpringVaadinServletService;
import io.devbench.uibuilder.data.common.dataprovidersupport.DataProviderRequestHandler;
import io.devbench.uibuilder.spring.ErrorHandlerRegistrator;
import io.devbench.uibuilder.spring.configuration.staticcontent.StaticContentDescription;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;

public final class UIBuilderSpringVaadinServletService
extends SpringVaadinServletService {
    @Nullable
    private final StaticContentDescription staticContentDescription;

    public UIBuilderSpringVaadinServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration, ApplicationContext context, StaticContentDescription staticContentDescription) {
        super(servlet, deploymentConfiguration, context);
        this.staticContentDescription = staticContentDescription;
    }

    protected List<RequestHandler> createRequestHandlers() throws ServiceException {
        List requestHandlers = super.createRequestHandlers();
        requestHandlers.add(new ErrorHandlerRegistrator());
        requestHandlers.add(new DataProviderRequestHandler());
        return requestHandlers;
    }

    public URL getStaticResource(String path) {
        String requestedPath;
        if (this.staticContentDescription != null && (requestedPath = this.prefixPathIfNecessary(path)).indexOf(this.staticContentDescription.getUrl()) == 0) {
            String withoutStaticPrefix = requestedPath.substring(this.staticContentDescription.getUrl().length());
            return this.staticContentDescription.getPaths().stream().map(baseDir -> baseDir + withoutStaticPrefix).map(UIBuilderSpringVaadinServletService.class::getResource).filter(Objects::nonNull).findFirst().orElseGet(() -> super.getStaticResource(path));
        }
        return super.getStaticResource(path);
    }

    private String prefixPathIfNecessary(String path) {
        if (path.indexOf("/frontend") == 0) {
            path = path.substring("/frontend".length());
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }
}

