/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.startup;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.devbench.uibuilder.annotations.ControllerBean;
import io.devbench.uibuilder.api.exceptions.InternalResolverException;
import io.devbench.uibuilder.api.exceptions.NoUniqueBeanNameFoundException;
import io.devbench.uibuilder.api.member.scanner.MemberScanner;
import io.devbench.uibuilder.api.parse.backendtemplate.BackendTemplateManager;
import io.devbench.uibuilder.components.i18n.pageloaderprocessor.CollectI18NMessagesProcessor;
import io.devbench.uibuilder.core.controllerbean.ControllerBeanManager;
import io.devbench.uibuilder.core.controllerbean.ControllerBeanProvidersHolder;
import io.devbench.uibuilder.core.page.PageLoader;
import io.devbench.uibuilder.core.page.pageloaderprocessors.AddHtmlImportsProcessor;
import io.devbench.uibuilder.core.page.pageloaderprocessors.PageLoaderProcessor;
import io.devbench.uibuilder.core.parse.PageTransformersRegistry;
import io.devbench.uibuilder.core.parse.ParseInterceptorsRegistry;
import io.devbench.uibuilder.core.startup.ComponentTagRegistry;
import io.devbench.uibuilder.data.api.datasource.DataSourceManager;
import io.devbench.uibuilder.data.api.datasource.DataSourceProvider;
import io.devbench.uibuilder.data.api.filter.validation.FilterValidationExecutor;
import io.devbench.uibuilder.i18n.core.I;
import io.devbench.uibuilder.i18n.core.interfaces.LanguageProvider;
import io.devbench.uibuilder.spring.configuration.basepackages.UIBuilderScanPackages;
import io.devbench.uibuilder.spring.data.SpringDataSourceProvider;
import io.devbench.uibuilder.spring.scanner.MemberComponentProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class RegistryInitializer {
    private static final Logger log = LoggerFactory.getLogger(RegistryInitializer.class);
    private final ApplicationContext applicationContext;
    private final UIBuilderScanPackages scanPackages;

    public RegistryInitializer(ApplicationContext applicationContext, UIBuilderScanPackages scanPackages) throws Exception {
        this.applicationContext = applicationContext;
        this.scanPackages = scanPackages;
        this.initializeMemberScanner();
        this.initializeComponentTagRegistry();
        this.initializeDataSourceManager();
        this.initializeParseInterceptors();
        this.initializeBackendTemplateManager();
        this.initializeLanguageProvider();
        this.initializePageTransformers();
        this.initializeControllerBeanManager();
        this.initializeFilterValidatorFacory();
        PageLoader.registerProcessorAfter(AddHtmlImportsProcessor.class, (PageLoaderProcessor)new CollectI18NMessagesProcessor());
    }

    private void initializeFilterValidatorFacory() {
        FilterValidationExecutor.registerToActiveContext();
    }

    private void initializeMemberScanner() {
        MemberScanner.registerToActiveContext(this::findClassesAnnotatedWith, this::findClassesBySuperType);
    }

    private void initializeDataSourceManager() {
        if (this.applicationContext.getBeanNamesForType(SpringDataSourceProvider.class).length == 1) {
            SpringDataSourceProvider dataSourceProvider = (SpringDataSourceProvider)this.applicationContext.getBean(SpringDataSourceProvider.class);
            Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses = dataSourceProvider.getInterestedAnnotationTypes().stream().collect(Collectors.toMap(Function.identity(), annotationType -> this.findClassesAnnotatedWith((Class<? extends Annotation>)annotationType, true)));
            dataSourceProvider.initialize(annotatedClasses);
            DataSourceManager.registerToActiveContext((DataSourceProvider)dataSourceProvider);
        }
    }

    private void initializeLanguageProvider() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Config conf = ConfigFactory.load();
        I.loadTranslations((String)((String)conf.getStringList("translationsDir").get(0)));
        I.setLanguageProvider((LanguageProvider)((LanguageProvider)Class.forName(conf.getString("activeLanguageProvider")).newInstance()));
    }

    private void initializeComponentTagRegistry() {
        ComponentTagRegistry.registerToActiveContext();
    }

    private void initializePageTransformers() {
        PageTransformersRegistry.registerToActiveContext();
    }

    private void initializeParseInterceptors() {
        ParseInterceptorsRegistry.registerToActiveContext();
    }

    private void initializeBackendTemplateManager() {
        BackendTemplateManager.registerToActiveContext();
    }

    private void initializeControllerBeanManager() {
        ControllerBeanProvidersHolder providersHolder = ControllerBeanProvidersHolder.builder().beanInstanceByClass(arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0)).beanInstanceByName(arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0)).beanNameByClass(this::getUniqueBeanNameForControllerBeanType).build();
        ControllerBeanManager.registerToActiveContext((ControllerBeanProvidersHolder)providersHolder, ControllerBean.class);
    }

    private Set<Class<?>> findClassesAnnotatedWith(Class<? extends Annotation> annotationType, boolean considerInterfaces) {
        MemberComponentProvider provider = new MemberComponentProvider(considerInterfaces, this.applicationContext.getEnvironment());
        provider.setResourceLoader((ResourceLoader)this.applicationContext);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        return this.findActualClassesByComponentProvider(provider).collect(Collectors.toSet());
    }

    private <SUPER_TYPE> Set<Class<? extends SUPER_TYPE>> findClassesBySuperType(Class<SUPER_TYPE> superClass, boolean considerInterfaces) {
        MemberComponentProvider provider = new MemberComponentProvider(considerInterfaces, this.applicationContext.getEnvironment());
        provider.setResourceLoader((ResourceLoader)this.applicationContext);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(superClass));
        return this.findActualClassesByComponentProvider(provider).map(clazz -> clazz).collect(Collectors.toSet());
    }

    private Stream<Class<?>> findActualClassesByComponentProvider(ClassPathScanningCandidateComponentProvider provider) {
        return this.scanPackages.getScanPackages().stream().map(arg_0 -> ((ClassPathScanningCandidateComponentProvider)provider).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(this::getBeanClass);
    }

    private String getUniqueBeanNameForControllerBeanType(Class<?> clazz) {
        String[] beanNamesForType = this.applicationContext.getBeanNamesForType(clazz);
        if (beanNamesForType.length == 1) {
            return beanNamesForType[0];
        }
        return this.getControllerBeanNameFromAnnotation(clazz).orElseThrow(() -> new NoUniqueBeanNameFoundException(clazz));
    }

    private Optional<String> getControllerBeanNameFromAnnotation(Class<?> clazz) {
        ControllerBean annotation = clazz.getAnnotation(ControllerBean.class);
        if (annotation != null && !annotation.value().trim().isEmpty()) {
            return Optional.of(annotation.value());
        }
        Class<?> superClass = clazz.getSuperclass();
        return superClass != null ? this.getControllerBeanNameFromAnnotation(superClass) : Optional.empty();
    }

    private Class<?> getBeanClass(BeanDefinition beanDefinition) {
        Class beanClass;
        AbstractBeanDefinition definition = (AbstractBeanDefinition)beanDefinition;
        if (definition.hasBeanClass()) {
            beanClass = definition.getBeanClass();
        } else {
            try {
                beanClass = definition.resolveBeanClass(this.applicationContext.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new InternalResolverException((Throwable)e);
            }
        }
        return beanClass;
    }
}

