/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import io.devbench.uibuilder.core.page.PageLoader;
import io.devbench.uibuilder.core.page.PageLoaderContext;
import io.devbench.uibuilder.core.page.pageloaderprocessors.PageUnloadProcessor;
import io.devbench.uibuilder.spring.page.BeanClassNotFoundException;
import io.devbench.uibuilder.spring.page.BeanStore;
import io.devbench.uibuilder.spring.page.BeanStoreWrapper;
import io.devbench.uibuilder.spring.page.PageScope;
import io.devbench.uibuilder.spring.page.PageScopeBeanId;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UIBuilderPageScope
implements Scope,
BeanFactoryPostProcessor {
    public static final String UIBUILDER_PAGE_SCOPE = "uibuilder-page";
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.beanFactory.registerScope(UIBUILDER_PAGE_SCOPE, (Scope)this);
        PageLoader.registerUnloadProcessor((PageUnloadProcessor)new PageUnloadProcessor(){

            public void process(PageLoaderContext context) {
                context.getPageContextIds().forEach(contextId -> UIBuilderPageScope.this.unloadPage((String)contextId));
            }
        });
    }

    @NotNull
    public Object get(@NotNull String name, @NotNull ObjectFactory<?> objectFactory) {
        PageScopeBeanId beanId = this.getBeanIdForBean(name);
        return this.getBeanStore().get(beanId, objectFactory);
    }

    private PageScopeBeanId getBeanIdForBean(String name) {
        try {
            String beanClassName = this.beanFactory.getBeanDefinition(name).getBeanClassName();
            Class<?> beanClass = Class.forName(beanClassName);
            PageScope annotation = beanClass.getAnnotation(PageScope.class);
            return PageScopeBeanId.of(name, annotation.value());
        }
        catch (ClassNotFoundException e) {
            throw new BeanClassNotFoundException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanStore<PageScopeBeanId> getBeanStore() {
        VaadinSession session = VaadinSession.getCurrent();
        try {
            session.lock();
            BeanStoreWrapper attribute = (BeanStoreWrapper)session.getAttribute(BeanStoreWrapper.class);
            if (attribute == null) {
                attribute = new BeanStoreWrapper(session);
                session.setAttribute(BeanStoreWrapper.class, (Object)attribute);
            }
            BeanStore<PageScopeBeanId> beanStore = attribute.getBeanStore(UI.getCurrent(), PageScopeBeanId.class);
            return beanStore;
        }
        finally {
            session.unlock();
        }
    }

    @Nullable
    public Object remove(@NotNull String name) {
        throw new UnsupportedOperationException();
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.getBeanStore().registerDestructionCallback(this.getBeanIdForBean(name), callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    public void unloadPage(String pageId) {
        this.getBeanStore().destroyBeans(id -> Objects.equals(id.getPageName(), pageId));
    }
}

