/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import io.devbench.uibuilder.spring.applicationcontext.AppCtx;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorHandlerRegistrator
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlerRegistrator.class);

    ErrorHandlerRegistrator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) {
        try {
            if (!session.hasLock()) {
                session.lock();
            }
            session.setErrorHandler(this::handleError);
        }
        finally {
            session.unlock();
        }
        return false;
    }

    private void handleError(ErrorEvent event) {
        ErrorHandler errorHandler = AppCtx.bean(ErrorHandler.class);
        if (errorHandler != null) {
            errorHandler.error(event);
        } else {
            Dialog dialog = new Dialog();
            VerticalLayout verticalLayout = new VerticalLayout(new Component[]{new H3("Internal error."), new Label("Please notify the Administrator."), new Button("Ok", (ComponentEventListener & Serializable)ignore -> dialog.close())});
            verticalLayout.setAlignItems(FlexComponent.Alignment.CENTER);
            dialog.add(new Component[]{verticalLayout});
            dialog.open();
            log.error("Internal error", event.getThrowable());
        }
    }
}

