/*
 *
 * Copyright © 2018 Webvalto Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.devbench.uibuilder.spring.applicationcontext;

import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AppCtx implements ApplicationContextAware {

    private static ApplicationContext context = null;

    @Nullable
    public static <T> T bean(Class<T> clazz) {
        try {
            return context.getBean(clazz);
        } catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static <T> T bean(String name, Class<T> clazz) {
        return context.getBean(name, clazz);
    }

    @Nullable
    public static Object bean(String name) {
        try {
            return context.getBean(name);
        } catch (Exception e) {
            return null;
        }
    }

    public static boolean containsBean(String beanName) {
        return context.containsBean(beanName);
    }

    public static void registerBean(String name, Class clazz, BeanDefinitionCustomizer... beanDefinitionCustomizers) {
        ((GenericApplicationContext) context).registerBean(name, clazz, beanDefinitionCustomizers);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static void remove(String beanName) {
        final AutowireCapableBeanFactory autowireCapableBeanFactory = context.getAutowireCapableBeanFactory();
        if (autowireCapableBeanFactory instanceof BeanDefinitionRegistry) {
            ((BeanDefinitionRegistry) autowireCapableBeanFactory).removeBeanDefinition(beanName);
        }

    }

}
