/*
 * Decompiled with CFR 0.152.
 */
package io.denkbar.smb.core;

import io.denkbar.smb.core.Message;
import io.denkbar.smb.core.MessageListener;
import io.denkbar.smb.core.MessageRouter;
import io.denkbar.smb.core.MessageRouterStateListener;
import io.denkbar.smb.core.SynchronMessageListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements MessageRouterStateListener {
    private String agentHost;
    private int agentPort;
    private MessageRouter router;
    private boolean isAlive;

    public Client() {
    }

    public Client(String agentHost, int agentPort) throws UnknownHostException, IOException {
        this.agentHost = agentHost;
        this.agentPort = agentPort;
        this.connect(agentHost, agentPort);
        this.start();
    }

    public void connect(String agentHost, int agentPort) throws IOException, UnknownHostException {
        this.setMessageRouter(new Socket(agentHost, agentPort));
    }

    public void start() {
        this.router.start();
    }

    public ConnectionFuture prepareForIncommingConnection() throws IOException {
        return new ConnectionFuture();
    }

    private void setMessageRouter(Socket socket) throws IOException {
        this.router = new MessageRouter(this, socket);
        this.isAlive = true;
    }

    public void sendMessage(String command) throws IOException {
        this.sendMessage(command, null);
    }

    public void sendMessage(String command, Object content) throws IOException {
        this.router.send(new Message(command, content));
    }

    public Object call(String command, Object content) throws Exception {
        return this.call(command, content, 60000L);
    }

    public Object call(String command, Object content, long timeout) throws Exception {
        return this.router.call(new Message(command, content), timeout);
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public MessageRouter getMessageRouter() {
        return this.router;
    }

    @Override
    public void messageRouterDisconnected(MessageRouter router) {
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void close() {
        this.router.disconnect();
        this.isAlive = false;
    }

    public void registerPermanentListener(String type, MessageListener listener) {
        this.router.registerPermanentListener(type, listener);
    }

    public void registerPermanentListenerForAllMessages(MessageListener listener) {
        this.router.registerPermanentListenerForAllMessages(listener);
    }

    public void registerSynchronListener(String type, SynchronMessageListener listener) {
        this.router.registerSynchronListener(type, listener);
    }

    public void unregisterPermanentListener(String type, MessageListener listener) {
        this.router.unregisterPermanentListener(type, listener);
    }

    public <T> T getProxy(Class<T> interfaceClass, long calltimeout) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, this.getInvocationHandler(interfaceClass, calltimeout));
    }

    public <T> InvocationHandler getInvocationHandler(final Class<T> interfaceClass, final long calltimeout) {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object[] params = new Object[]{method.getName(), args};
                return Client.this.call(interfaceClass.getName(), params, calltimeout);
            }
        };
    }

    public <T> void registerSynchronListener(final Class<T> interfaceClass, final T listener) {
        this.registerSynchronListener(interfaceClass.getName(), new SynchronMessageListener(){

            @Override
            public Serializable onSynchronMessage(Message msg) throws Exception {
                int argsCount;
                Object[] content = (Object[])msg.getContent();
                Object[] args = (Object[])content[1];
                int n = argsCount = args != null ? args.length : 0;
                if (argsCount == 0) {
                    args = new Object[]{};
                }
                Class[] types = new Class[argsCount];
                for (int i = 0; i < argsCount; ++i) {
                    types[i] = args[i].getClass();
                }
                String methodName = (String)content[0];
                Method method = this.getMethodMatchingSignature(interfaceClass, methodName, types);
                if (method != null) {
                    Object result = method.invoke(listener, args);
                    return (Serializable)result;
                }
                throw new RuntimeException("No method matching found");
            }

            private <T> Method getMethodMatchingSignature(Class<T> interfaceClass2, String methodName, Class<?>[] types) {
                for (Method m : interfaceClass2.getMethods()) {
                    if (!m.getName().equals(methodName) || m.getParameters().length != types.length) continue;
                    boolean match = true;
                    for (int i = 0; i < m.getParameterTypes().length; ++i) {
                        Class<?> methodType = m.getParameterTypes()[i];
                        if (methodType.isAssignableFrom(types[i])) continue;
                        match = false;
                    }
                    if (!match) continue;
                    return m;
                }
                return null;
            }
        });
    }

    public class ConnectionFuture {
        ServerSocket serverSocket = new ServerSocket(0);

        public ConnectionFuture() throws IOException {
            final ConnectionFuture me = this;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Socket socket = ConnectionFuture.this.serverSocket.accept();
                        ConnectionFuture connectionFuture = me;
                        synchronized (connectionFuture) {
                            Client.this.setMessageRouter(socket);
                            me.notifyAll();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            ConnectionFuture.this.serverSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }).start();
        }

        public int getLocalPort() {
            return this.serverSocket.getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForConnection(long timeout) throws TimeoutException, InterruptedException {
            ConnectionFuture connectionFuture = this;
            synchronized (connectionFuture) {
                if (!Client.this.isAlive) {
                    this.wait(timeout);
                }
            }
            if (!Client.this.isAlive) {
                throw new TimeoutException("Timeout occured while waiting for connection.");
            }
        }
    }
}

