/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.utils;

import defaultj.core.utils.AnnotationUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public class MethodUtils {
    public static Predicate<Method> ifPublicMethod = method -> MethodUtils._isPublic(method);
    public static Predicate<Method> ifStaticMethod = method -> MethodUtils._isStatic(method);

    public static boolean _isPublic(Method method) {
        if (method == null) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean _isStatic(Method method) {
        if (method == null) {
            return false;
        }
        return Modifier.isStatic(method.getModifiers());
    }

    public static Predicate<Method> annotatedWith(String ... names) {
        return method -> AnnotationUtils.has(method.getAnnotations(), names);
    }
}

