/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.utils;

import defaultj.api.IProvideDefault;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import nullablej.nullable.Nullable;

public class MethodSupplierFinderUtils {
    public static Object[] prepareParameters(Method method, IProvideDefault defaultProvider) {
        Parameter[] paramsArray = method.getParameters();
        Object[] paramValues = MethodSupplierFinderUtils.getParameters(paramsArray, defaultProvider);
        return paramValues;
    }

    public static Object[] prepareParameters(Constructor<?> constructor, IProvideDefault defaultProvider) {
        Parameter[] paramsArray = constructor.getParameters();
        Object[] paramValues = MethodSupplierFinderUtils.getParameters(paramsArray, defaultProvider);
        return paramValues;
    }

    private static Object[] getParameters(Parameter[] paramsArray, IProvideDefault defaultProvider) {
        Object[] params = new Object[paramsArray.length];
        for (int i = 0; i < paramsArray.length; ++i) {
            Object paramValue;
            Parameter param = paramsArray[i];
            Class<?> paramType = param.getType();
            Type parameterizedType = param.getParameterizedType();
            boolean isNullable = AnnotationUtils.has(param.getAnnotations(), "Nullable") || AnnotationUtils.has(param.getAnnotations(), "Optional");
            params[i] = paramValue = MethodSupplierFinderUtils.determineParameterValue(paramType, parameterizedType, isNullable, defaultProvider);
        }
        return params;
    }

    private static Object determineParameterValue(Class paramType, Type type, boolean canBeNull, IProvideDefault defaultProvider) {
        if (type instanceof ParameterizedType) {
            boolean isNullable;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (Failable.Supplier.class.isAssignableFrom(paramType)) {
                return () -> {
                    Object value = defaultProvider.get(actualType);
                    return value;
                };
            }
            if (Supplier.class.isAssignableFrom(paramType)) {
                return () -> {
                    Object value = defaultProvider.get(actualType);
                    return value;
                };
            }
            boolean isOptional = Optional.class.isAssignableFrom(paramType);
            boolean bl = isNullable = !isOptional && Nullable.class.isAssignableFrom(paramType);
            if (isOptional || isNullable) {
                return MethodSupplierFinderUtils.getNullableOrOptionalValue(canBeNull, defaultProvider, actualType, isOptional);
            }
        }
        if (canBeNull) {
            return MethodSupplierFinderUtils.getValueOrNullWhenFail(paramType, defaultProvider);
        }
        Object value = defaultProvider.get(paramType);
        return value;
    }

    private static Object getNullableOrOptionalValue(boolean canBeNull, IProvideDefault defaultProvider, Class actualType, boolean isOptional) {
        Function<Object, Object> noException = isOptional ? Optional::ofNullable : Nullable::of;
        Supplier<Object> withException = isOptional ? Optional::empty : Nullable::empty;
        try {
            Object paramValue = defaultProvider.get(actualType);
            return noException.apply(paramValue);
        }
        catch (Exception e) {
            return canBeNull ? null : withException.get();
        }
    }

    private static Object getValueOrNullWhenFail(Class paramType, IProvideDefault defaultProvider) {
        try {
            return defaultProvider.get(paramType);
        }
        catch (Exception e) {
            return null;
        }
    }
}

