/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.utils;

import defaultj.core.exception.DefaultCreationException;
import defaultj.core.utils.AnnotationUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;

public class ConstructorUtils {
    public static boolean _isPublic(Constructor<?> constructor) {
        if (constructor == null) {
            return false;
        }
        return Modifier.isPublic(constructor.getModifiers());
    }

    public static <T> Supplier<Constructor<T>> sensibleDefaultConstructorOf(Class<T> clzz) {
        return () -> ConstructorUtils.hasOnlyOneConsructor(clzz) ? ConstructorUtils.getOnlyConstructor(clzz) : ConstructorUtils.getNoArgConstructor(clzz);
    }

    public static <T> Constructor<T> findConstructorWithAnnotation(Class<T> clzz, String ... annotationNames) {
        for (Constructor<?> constructor : clzz.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || !AnnotationUtils.has(constructor.getAnnotations(), annotationNames)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> boolean hasOnlyOneConsructor(Class<T> clzz) {
        return clzz.getConstructors().length == 1;
    }

    public static <T> Constructor<T> getNoArgConstructor(Class<T> clzz) {
        try {
            return clzz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            throw new DefaultCreationException(clzz);
        }
    }

    public static <T> Constructor<T> getOnlyConstructor(Class<T> clzz) {
        return clzz.getConstructors()[0];
    }
}

