/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.Default;
import defaultj.api.IProvideDefault;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.MethodSupplierFinderUtils;
import defaultj.core.utils.MethodUtils;
import defaultj.core.utils.failable.Failable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import nullablej.NullableJ;
import nullablej.nullable.Nullable;

public class FactoryMethodSupplierFinder
implements IFindSupplier {
    private static final String DEFAULT = Default.class.getSimpleName();
    private static final Predicate<Method> annotatedWithDefault = MethodUtils.annotatedWith(DEFAULT);

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        Failable.Supplier<TYPE, Throwable> methodValue = this.findValueFromFactoryMethod(theGivenClass, defaultProvider);
        return methodValue;
    }

    private <T> Failable.Supplier<T, ? extends Throwable> findValueFromFactoryMethod(Class<T> theGivenClass, IProvideDefault defaultProvider) {
        Helper helper = new Helper(theGivenClass, defaultProvider);
        Failable.Supplier supplier = NullableJ._stream$((Object[])theGivenClass.getDeclaredMethods()).filter(MethodUtils.ifStaticMethod).filter(MethodUtils.ifPublicMethod).filter(annotatedWithDefault).map(x$0 -> helper.findValue(x$0)).findAny().orElse(null);
        return supplier;
    }

    static final class Helper<T> {
        private final Class<T> theGivenClass;
        private final IProvideDefault defaultProvider;

        private Failable.Supplier findValue(Method method) {
            Class<?> type = method.getReturnType();
            if (this.theGivenClass.isAssignableFrom(type)) {
                return () -> this.basicFactoryMethodCall(method);
            }
            Failable.Supplier fromNullable = this.findNullableOrOptional(method, type);
            if (fromNullable != null) {
                return fromNullable;
            }
            Failable.Supplier fromSupplier = this.findSupplier(method, type);
            if (fromSupplier != null) {
                return fromSupplier;
            }
            return null;
        }

        private Failable.Supplier findSupplier(Method method, Class<?> type) {
            if (!Supplier.class.isAssignableFrom(type)) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (!this.theGivenClass.isAssignableFrom(actualType)) {
                return null;
            }
            Method getMethod = Helper.getGetMethod();
            return () -> this.supplierFactoryMethodCall(method, getMethod);
        }

        private Failable.Supplier findNullableOrOptional(Method method, Class<?> type) {
            boolean isNullable;
            boolean isOptional = Optional.class.isAssignableFrom(type);
            boolean bl = isNullable = !isOptional && Nullable.class.isAssignableFrom(type);
            if (!isOptional && !isNullable) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (!this.theGivenClass.isAssignableFrom(actualType)) {
                return null;
            }
            return () -> this.getNullableOrOptionalValue(method, isNullable);
        }

        private Object getNullableOrOptionalValue(Method method, boolean isNullable) throws IllegalAccessException, InvocationTargetException {
            Object[] params = MethodSupplierFinderUtils.prepareParameters(method, this.defaultProvider);
            Object nullable = method.invoke(this.theGivenClass, params);
            Object value = isNullable ? ((Nullable)nullable).orElse(null) : ((Optional)nullable).orElse(null);
            return value;
        }

        private static Method getGetMethod() {
            try {
                return Supplier.class.getMethod("get", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }

        private Object supplierFactoryMethodCall(Method method, Method getMethod) throws IllegalAccessException, InvocationTargetException {
            Object[] params = MethodSupplierFinderUtils.prepareParameters(method, this.defaultProvider);
            Object result = method.invoke(this.theGivenClass, params);
            Object value = getMethod.invoke(result, new Object[0]);
            return value;
        }

        private Object basicFactoryMethodCall(Method method) throws IllegalAccessException, InvocationTargetException {
            Object[] params = MethodSupplierFinderUtils.prepareParameters(method, this.defaultProvider);
            Object value = method.invoke(this.theGivenClass, params);
            return value;
        }

        public Helper(Class<T> theGivenClass, IProvideDefault defaultProvider) {
            this.theGivenClass = theGivenClass;
            this.defaultProvider = defaultProvider;
        }

        public Class<T> getTheGivenClass() {
            return this.theGivenClass;
        }

        public IProvideDefault getDefaultProvider() {
            return this.defaultProvider;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Helper)) {
                return false;
            }
            Helper other = (Helper)o;
            Class<T> this$theGivenClass = this.getTheGivenClass();
            Class<T> other$theGivenClass = other.getTheGivenClass();
            if (this$theGivenClass == null ? other$theGivenClass != null : !this$theGivenClass.equals(other$theGivenClass)) {
                return false;
            }
            IProvideDefault this$defaultProvider = this.getDefaultProvider();
            IProvideDefault other$defaultProvider = other.getDefaultProvider();
            return !(this$defaultProvider == null ? other$defaultProvider != null : !this$defaultProvider.equals(other$defaultProvider));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $theGivenClass = this.getTheGivenClass();
            result = result * 59 + ($theGivenClass == null ? 43 : $theGivenClass.hashCode());
            IProvideDefault $defaultProvider = this.getDefaultProvider();
            result = result * 59 + ($defaultProvider == null ? 43 : $defaultProvider.hashCode());
            return result;
        }

        public String toString() {
            return "FactoryMethodSupplierFinder.Helper(theGivenClass=" + this.getTheGivenClass() + ", defaultProvider=" + this.getDefaultProvider() + ")";
        }
    }
}

