/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.DefaultImplementation;
import defaultj.api.IProvideDefault;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import defaultj.core.utils.failable.Failables;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import nullablej.NullableJ;

public class DefaultImplementationSupplierFinder
implements IFindSupplier {
    private static final String ANNOTATION_NAME = DefaultImplementation.class.getSimpleName();
    private static final Function<String, String> extractValue = toString -> toString.replaceAll("^(.*\\(value=)(.*)(\\))$", "$2");
    private static final Function<Object, String> toString = Object::toString;
    private static final Predicate<Object> notNull = Objects::nonNull;

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        if (!AnnotationUtils.has(theGivenClass.getAnnotations(), ANNOTATION_NAME)) {
            return null;
        }
        Class defaultImplementationClass = DefaultImplementationSupplierFinder.findDefaultImplementation(theGivenClass);
        if (defaultImplementationClass == null) {
            return null;
        }
        return Failables.of(() -> defaultProvider.get(defaultImplementationClass));
    }

    private static <T> Class<T> findDefaultImplementation(Class<T> theGivenClass) {
        Class implementedClass = NullableJ._stream$((Object[])theGivenClass.getAnnotations()).map(toString).map(extractValue).map(DefaultImplementationSupplierFinder.findClass()).filter(notNull).filter(DefaultImplementationSupplierFinder.isAssignableTo(theGivenClass)).findAny().orElse(null);
        return implementedClass;
    }

    private static <T> Function<String, Class<T>> findClass() {
        return name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
    }

    private static <T> Predicate<Class<T>> isAssignableTo(Class<?> theGivenClass) {
        return theGivenClass::isAssignableFrom;
    }
}

