/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.Actions;
import io.deepstream.ConnectionState;
import io.deepstream.ConnectionStateListener;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.Event;
import io.deepstream.Message;
import io.deepstream.Topic;
import io.deepstream.UtilTimeoutListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class UtilAckTimeoutRegistry
implements ConnectionStateListener,
UtilTimeoutListener {
    private final Map<String, ScheduledFuture> register;
    private final ScheduledExecutorService executor;
    private final DeepstreamClientAbstract client;
    private final LinkedBlockingQueue<AckTimeout> ackTimers;
    private ConnectionState state;

    @ObjectiveCName(value="init:")
    UtilAckTimeoutRegistry(DeepstreamClientAbstract client) {
        this.client = client;
        this.register = new ConcurrentHashMap<String, ScheduledFuture>();
        this.ackTimers = new LinkedBlockingQueue();
        this.executor = new ScheduledThreadPoolExecutor(5);
        this.state = client.getConnectionState();
        this.client.addConnectionChangeListener(this);
    }

    @ObjectiveCName(value="clear:")
    void clear(Message message) {
        String name;
        Actions action;
        if (message.action == Actions.ACK) {
            action = Actions.getAction(message.data[0]);
            name = message.data[1];
        } else {
            action = message.action;
            name = message.data[0];
        }
        String uniqueName = this.getUniqueName(message.topic, action, name);
        if (!this.clear(uniqueName)) {
            this.client.onError(message.topic, Event.UNSOLICITED_MESSAGE, message.raw);
        }
    }

    @ObjectiveCName(value="clear:action:name:")
    void clear(Topic topic, Actions action, String name) {
        String uniqueName = this.getUniqueName(topic, action, name);
        this.clear(uniqueName);
    }

    @ObjectiveCName(value="add:action:name:event:timeout:")
    void add(Topic topic, Actions action, String name, Event event, int timeout) {
        this.add(topic, action, name, event, this, timeout);
    }

    @ObjectiveCName(value="add:action:name:timeout:")
    void add(Topic topic, Actions action, String name, int timeout) {
        this.add(topic, action, name, Event.ACK_TIMEOUT, this, timeout);
    }

    @ObjectiveCName(value="add:action:name:event:timeoutListener:timeout:")
    void add(Topic topic, Actions action, String name, Event event, UtilTimeoutListener timeoutListener, int timeout) {
        String uniqueName = this.getUniqueName(topic, action, name);
        this.clear(uniqueName);
        this.addToRegister(topic, action, name, event, timeoutListener, timeout);
    }

    @Override
    @ObjectiveCName(value="connectionStateChanged:")
    public void connectionStateChanged(ConnectionState connectionState) {
        if (connectionState == ConnectionState.OPEN) {
            this.scheduleAcks();
        }
        this.state = connectionState;
    }

    void close() {
        this.executor.shutdown();
    }

    @ObjectiveCName(value="clearWithUniqueName:")
    private boolean clear(String uniqueName) {
        ScheduledFuture scheduledFuture = this.register.get(uniqueName);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.register.remove(uniqueName);
            return true;
        }
        return false;
    }

    @ObjectiveCName(value="addToRegister:action:name:event:timeoutListener:timeoutDuration:")
    private void addToRegister(Topic topic, Actions action, String name, Event event, UtilTimeoutListener timeoutListener, int timeoutDuration) {
        AckTimeout task = new AckTimeout(topic, action, name, event, timeoutListener, timeoutDuration);
        if (this.state == ConnectionState.OPEN) {
            ScheduledFuture<?> scheduledFuture = this.executor.schedule(task, (long)timeoutDuration, TimeUnit.MILLISECONDS);
            String uniqueName = this.getUniqueName(topic, action, name);
            this.register.put(uniqueName, scheduledFuture);
        } else {
            this.ackTimers.add(task);
        }
    }

    @Override
    @ObjectiveCName(value="onTimeout:action:event:name:")
    public void onTimeout(Topic topic, Actions action, Event event, String name) {
        String uniqueName = this.getUniqueName(topic, action, name);
        this.register.remove(uniqueName);
    }

    private void scheduleAcks() {
        AckTimeout task = null;
        while (this.ackTimers.peek() != null) {
            try {
                task = this.ackTimers.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (task != null) {
                this.executor.schedule(task, (long)task.timeout, TimeUnit.MICROSECONDS);
            }
            task = null;
        }
    }

    @ObjectiveCName(value="getUniqueName:action:name:")
    private String getUniqueName(Topic topic, Actions action, String name) {
        return topic.toString() + action.toString() + name;
    }

    private class AckTimeout
    implements Runnable {
        private final UtilTimeoutListener timeoutListener;
        private final Topic topic;
        private final Actions action;
        private final String name;
        private final Event event;
        private final int timeout;

        @ObjectiveCName(value="init:action:name:event:timeoutListener:timeout:")
        AckTimeout(Topic topic, Actions action, String name, Event event, UtilTimeoutListener timeoutListener, int timeout) {
            this.topic = topic;
            this.action = action;
            this.name = name;
            this.event = event;
            this.timeoutListener = timeoutListener;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            this.timeoutListener.onTimeout(this.topic, this.action, this.event, this.name);
            String msg = this.event == Event.ACK_TIMEOUT ? "No ACK message received in time for " + this.action.name() + " " + this.name : "No message received in time for " + this.action.name() + " " + this.name;
            UtilAckTimeoutRegistry.this.client.onError(this.topic, this.event, msg);
        }
    }
}

