/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

class UtilJSONPath {
    private JsonElement coreElement;

    public UtilJSONPath(JsonElement e) {
        this.coreElement = e;
    }

    private static JsonElement getIterateThrough(JsonElement element, String path) {
        ArrayList<Object> tokens = UtilJSONPath.tokenize(path);
        JsonElement traverser = element;
        Object token = null;
        for (int i = 0; i < tokens.size(); ++i) {
            token = tokens.get(i);
            try {
                if (traverser == null || traverser.isJsonNull()) break;
                if (traverser.isJsonObject()) {
                    traverser = traverser.getAsJsonObject().get((String)token);
                    continue;
                }
                if (traverser.isJsonArray()) {
                    traverser = traverser.getAsJsonArray().get(((Integer)token).intValue());
                    continue;
                }
                traverser = null;
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return traverser;
    }

    private static ArrayList<Object> tokenize(String path) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        String[] parts = path.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() == 0) continue;
            String[] arrayIndexes = part.split("[\\[\\]]");
            tokens.add(arrayIndexes[0].trim());
            for (int j = 1; j < arrayIndexes.length; ++j) {
                if (arrayIndexes[j].length() == 0) continue;
                tokens.add(Integer.valueOf(arrayIndexes[j].trim()));
            }
        }
        return tokens;
    }

    private static JsonElement setIterateThrough(JsonElement element, String path, JsonElement value, boolean delete) {
        ArrayList<Object> tokens = UtilJSONPath.tokenize(path);
        JsonElement[] nodes = new JsonElement[tokens.size()];
        nodes[0] = element;
        JsonElement traverser = null;
        Object token = null;
        for (int i = 0; i < tokens.size(); ++i) {
            JsonElement child;
            Object nextToken;
            JsonElement parent = nodes[i];
            token = tokens.get(i);
            try {
                nextToken = tokens.get(i + 1);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            if (parent.isJsonObject()) {
                child = parent.getAsJsonObject().get((String)token);
                if (child != null) {
                    if (nextToken instanceof String && child.isJsonObject()) {
                        traverser = parent.getAsJsonObject().get((String)token);
                    } else if (nextToken instanceof String && !child.isJsonObject()) {
                        parent.getAsJsonObject().add((String)token, (JsonElement)new JsonObject());
                        traverser = parent.getAsJsonObject().get((String)token);
                    } else if (nextToken instanceof Integer && child.isJsonArray()) {
                        traverser = parent.getAsJsonObject().get((String)token);
                    } else if (nextToken instanceof Integer && !child.isJsonArray()) {
                        parent.getAsJsonObject().add((String)token, (JsonElement)UtilJSONPath.initialiseArray((Integer)nextToken));
                        traverser = parent.getAsJsonObject().get((String)token);
                    }
                } else if (nextToken instanceof Integer) {
                    parent.getAsJsonObject().add((String)token, (JsonElement)UtilJSONPath.initialiseArray((Integer)nextToken));
                    traverser = parent.getAsJsonObject().get((String)token);
                } else {
                    parent.getAsJsonObject().add((String)token, (JsonElement)new JsonObject());
                    traverser = parent.getAsJsonObject().get((String)token);
                }
            } else if (parent.isJsonArray()) {
                child = null;
                try {
                    parent.getAsJsonArray().get(((Integer)token).intValue());
                }
                catch (IndexOutOfBoundsException e) {
                    UtilJSONPath.extendArray(parent.getAsJsonArray(), (Integer)token);
                    if (nextToken instanceof Integer) {
                        JsonArray array = UtilJSONPath.initialiseArray((Integer)nextToken);
                        parent.getAsJsonArray().set(((Integer)token).intValue(), (JsonElement)array);
                        traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                    }
                    parent.getAsJsonArray().set(((Integer)token).intValue(), (JsonElement)new JsonObject());
                    traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                }
                child = parent.getAsJsonArray().get(((Integer)token).intValue());
                if (child != null) {
                    if (nextToken instanceof String && child.isJsonObject()) {
                        traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                    } else if (nextToken instanceof String && !child.isJsonObject()) {
                        parent.getAsJsonArray().set(((Integer)token).intValue(), (JsonElement)new JsonObject());
                        traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                    } else if (nextToken instanceof Integer && child.isJsonArray()) {
                        traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                    } else if (nextToken instanceof Integer && !child.isJsonArray()) {
                        parent.getAsJsonArray().set(((Integer)token).intValue(), (JsonElement)UtilJSONPath.initialiseArray((Integer)nextToken));
                        traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                    }
                } else if (nextToken instanceof Integer) {
                    parent.getAsJsonObject().add((String)token, (JsonElement)UtilJSONPath.initialiseArray((Integer)nextToken));
                    traverser = parent.getAsJsonObject().get((String)token);
                } else {
                    parent.getAsJsonObject().add((String)token, (JsonElement)new JsonObject());
                    traverser = parent.getAsJsonObject().get((String)token);
                }
                if (traverser.isJsonNull()) {
                    if (nextToken instanceof Integer) {
                        JsonArray arr = UtilJSONPath.initialiseArray((Integer)nextToken);
                        parent.getAsJsonArray().set(((Integer)token).intValue(), (JsonElement)arr);
                    } else if (nextToken instanceof String) {
                        parent.getAsJsonArray().set(((Integer)token).intValue(), (JsonElement)new JsonObject());
                    }
                    traverser = parent.getAsJsonArray().get(((Integer)token).intValue());
                }
                if (traverser.isJsonArray() && nextToken instanceof Integer && traverser.getAsJsonArray().size() < (Integer)nextToken) {
                    UtilJSONPath.extendArray(traverser.getAsJsonArray(), (Integer)nextToken);
                }
            }
            nodes[i + 1] = traverser;
        }
        if (token != null && (value != null || delete)) {
            UtilJSONPath.updateValue(value, nodes[nodes.length - 1], token, delete);
        }
        return traverser;
    }

    private static JsonArray initialiseArray(int size) {
        JsonArray array = new JsonArray();
        for (int j = 0; j < size + 1; ++j) {
            array.add((JsonElement)JsonNull.INSTANCE);
        }
        return array;
    }

    private static void extendArray(JsonArray array, int size) {
        for (int j = array.size(); j < size + 1; ++j) {
            array.add((JsonElement)JsonNull.INSTANCE);
        }
    }

    private static void updateValue(JsonElement value, JsonElement parent, Object token, boolean delete) {
        if (parent.isJsonObject()) {
            JsonObject object = (JsonObject)parent;
            if (delete) {
                object.remove((String)token);
            } else {
                object.add((String)token, value);
            }
        } else if (parent.isJsonArray()) {
            JsonArray object = (JsonArray)parent;
            int size = object.size();
            if (delete) {
                object.remove(((Integer)token).intValue());
            } else {
                for (int i = size; i <= (Integer)token; ++i) {
                    object.add((JsonElement)JsonNull.INSTANCE);
                }
                object.set(((Integer)token).intValue(), value);
            }
        }
    }

    private static JsonElement getArrayElement(JsonElement traverser, String token) {
        int index = Integer.valueOf(UtilJSONPath.getIndex(token));
        try {
            return traverser.getAsJsonObject().get(UtilJSONPath.getTokenPrefix(token)).getAsJsonArray().get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static String getTokenPrefix(String token) {
        return token.substring(0, token.indexOf("["));
    }

    private static String getIndex(String token) {
        return token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim();
    }

    private static boolean isArray(String token) {
        boolean isArray = token.contains("[") && token.contains("]") && token.indexOf("[") < token.indexOf("]");
        try {
            Integer.parseInt(token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim());
            return isArray;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JsonElement get(String path) {
        if (Objects.equals(path, "") || path == null) {
            return this.coreElement;
        }
        return UtilJSONPath.getIterateThrough(this.coreElement, path);
    }

    public void set(String path, JsonElement value) {
        if (Objects.equals(path, "")) {
            throw new RuntimeException("Setting an entire object must be done via setValue( JsonElement value );");
        }
        if (path == null) {
            this.coreElement = value;
        } else {
            UtilJSONPath.setIterateThrough(this.coreElement, path, value, false);
        }
    }

    protected void delete(String path) {
        UtilJSONPath.setIterateThrough(this.coreElement, path, null, true);
    }

    public JsonElement getCoreElement() {
        return this.coreElement;
    }

    public void setCoreElement(JsonElement coreElement) {
        this.coreElement = coreElement;
    }

    public class Array
    implements Iterable<UtilJSONPath> {
        private final JsonArray root;
        private JsonElement coreElement;

        public Array(JsonArray root) {
            this.root = root;
        }

        @Override
        public Iterator<UtilJSONPath> iterator() {
            return new Iterator<UtilJSONPath>(){
                final Iterator<JsonElement> it;
                {
                    this.it = Array.this.root.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public UtilJSONPath next() {
                    return new UtilJSONPath(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }
}

