/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.Connection;
import io.deepstream.Endpoint;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.handshake.ServerHandshake;

class JavaEndpointWebsocket
implements Endpoint {
    private final URI uri;
    private WebSocket websocket;
    private final Connection connection;

    JavaEndpointWebsocket(URI uri, Connection connection) throws URISyntaxException {
        this.uri = uri;
        this.connection = connection;
    }

    @Override
    public void send(String message) {
        this.websocket.send(message);
    }

    @Override
    public void close() {
        this.websocket.close();
        this.websocket = null;
    }

    @Override
    public void forceClose() {
        this.websocket.getConnection().closeConnection(1, "Forcing connection close due to network loss");
    }

    @Override
    public void open() {
        this.websocket = new WebSocket(this.uri, (Draft)new Draft_10());
        this.websocket.connect();
    }

    private class WebSocket
    extends WebSocketClient {
        WebSocket(URI serverUri, Draft draft) {
            super(serverUri, draft);
            if (serverUri.toString().startsWith("wss:")) {
                SSLContext sslContext;
                try {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, null, null);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                this.setWebSocketFactory((WebSocketClient.WebSocketClientFactory)new DefaultSSLWebSocketClientFactory(sslContext));
            }
        }

        public void onOpen(ServerHandshake handshakedata) {
            JavaEndpointWebsocket.this.connection.onOpen();
        }

        public void onMessage(String message) {
            JavaEndpointWebsocket.this.connection.onMessage(message);
        }

        public void onClose(int code, String reason, boolean remote) {
            try {
                JavaEndpointWebsocket.this.connection.onClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onError(Exception ex) {
            if (ex instanceof NullPointerException && ex.getMessage().equals("ssl == null")) {
                return;
            }
            JavaEndpointWebsocket.this.connection.onError(ex.getMessage());
        }
    }
}

