/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Objects;

class UtilJSONPath {
    private JsonElement coreElement;
    private Gson gson = new Gson();

    public UtilJSONPath(JsonElement e) {
        this.coreElement = e;
    }

    private static JsonElement getIterateThrough(JsonElement element, String path) {
        String[] st = path.split("\\.");
        JsonElement traverser = element;
        String token = null;
        for (int i = 0; i < st.length; ++i) {
            token = st[i];
            try {
                if (traverser.isJsonNull()) break;
                if (UtilJSONPath.isArray(token)) {
                    String prefix = UtilJSONPath.getTokenPrefix(token);
                    int index = Integer.parseInt(UtilJSONPath.getIndex(token));
                    traverser = traverser.getAsJsonObject().get(prefix).getAsJsonArray().get(index);
                    continue;
                }
                if (traverser.isJsonObject()) {
                    traverser = traverser.getAsJsonObject().get(token);
                    continue;
                }
                if (!traverser.isJsonArray()) continue;
                break;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return traverser;
    }

    private static JsonElement setIterateThrough(JsonElement element, String path, JsonElement value, boolean delete) {
        String[] st = path.split("\\.");
        JsonElement traverser = element;
        JsonElement parent = null;
        String token = null;
        for (int i = 0; i < st.length; ++i) {
            token = st[i];
            parent = traverser;
            if (traverser.isJsonNull()) break;
            if (UtilJSONPath.isArray(token)) {
                String prefix = UtilJSONPath.getTokenPrefix(token);
                token = UtilJSONPath.getIndex(token);
                int index = Integer.parseInt(token);
                JsonObject parentObject = traverser.getAsJsonObject();
                if (parentObject.get(prefix) == null) {
                    parentObject.add(prefix, (JsonElement)UtilJSONPath.initialiseArray(index));
                }
                try {
                    parentObject.get(prefix).getAsJsonArray().get(index);
                }
                catch (IndexOutOfBoundsException e) {
                    UtilJSONPath.extendArray(parentObject.get(prefix).getAsJsonArray(), index);
                }
                parent = parentObject.get(prefix);
                if (parentObject.get(prefix).getAsJsonArray().get(index).isJsonNull()) {
                    parentObject.get(prefix).getAsJsonArray().set(index, (JsonElement)new JsonObject());
                }
                traverser = parentObject.get(prefix).getAsJsonArray().get(index);
                continue;
            }
            if (traverser.isJsonObject()) {
                JsonElement property = traverser.getAsJsonObject().get(token);
                if (property == null) {
                    traverser.getAsJsonObject().add(token, (JsonElement)new JsonObject());
                }
                parent = traverser.getAsJsonObject();
                traverser = traverser.getAsJsonObject().get(token);
                continue;
            }
            if (traverser.isJsonArray()) break;
        }
        if (token != null && (value != null || delete)) {
            UtilJSONPath.updateValue(value, parent, token, delete);
        }
        return traverser;
    }

    private static JsonArray initialiseArray(int size) {
        JsonArray array = new JsonArray();
        for (int j = 0; j < size; ++j) {
            array.add((JsonElement)JsonNull.INSTANCE);
        }
        JsonObject temp = new JsonObject();
        array.add((JsonElement)temp);
        return array;
    }

    private static void extendArray(JsonArray array, int size) {
        for (int j = array.size(); j < size; ++j) {
            array.add((JsonElement)JsonNull.INSTANCE);
        }
        JsonObject temp = new JsonObject();
        array.add((JsonElement)temp);
    }

    private static void updateValue(JsonElement value, JsonElement parent, String token, boolean delete) {
        if (parent.isJsonObject()) {
            JsonObject object = (JsonObject)parent;
            if (delete) {
                object.remove(token);
            } else {
                object.add(token, value);
            }
        } else if (parent.isJsonArray()) {
            JsonArray object = (JsonArray)parent;
            int size = object.size();
            int index = Integer.parseInt(token);
            if (delete) {
                object.remove(index);
            } else {
                for (int i = size; i <= index; ++i) {
                    object.add((JsonElement)JsonNull.INSTANCE);
                }
                object.set(index, value);
            }
        }
    }

    private static JsonElement getArrayElement(JsonElement traverser, String token) {
        int index = Integer.valueOf(UtilJSONPath.getIndex(token));
        try {
            return traverser.getAsJsonObject().get(UtilJSONPath.getTokenPrefix(token)).getAsJsonArray().get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static String getTokenPrefix(String token) {
        return token.substring(0, token.indexOf("["));
    }

    private static String getIndex(String token) {
        return token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim();
    }

    private static boolean isArray(String token) {
        boolean isArray = token.contains("[") && token.contains("]") && token.indexOf("[") < token.indexOf("]");
        try {
            Integer.parseInt(token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim());
            return isArray;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JsonElement get(String path) {
        if (Objects.equals(path, "") || path == null) {
            return this.coreElement;
        }
        return UtilJSONPath.getIterateThrough(this.coreElement, path);
    }

    public void set(String path, JsonElement value) {
        if (Objects.equals(path, "")) {
            throw new RuntimeException("Setting an entire object must be done via setValue( JsonElement value );");
        }
        if (path == null) {
            this.coreElement = value;
        } else {
            UtilJSONPath.setIterateThrough(this.coreElement, path, value, false);
        }
    }

    protected void delete(String path) {
        UtilJSONPath.setIterateThrough(this.coreElement, path, null, true);
    }

    public JsonElement getCoreElement() {
        return this.coreElement;
    }

    public void setCoreElement(JsonElement coreElement) {
        this.coreElement = coreElement;
    }

    public class Array
    implements Iterable<UtilJSONPath> {
        private final JsonArray root;
        private JsonElement coreElement;

        public Array(JsonArray root) {
            this.root = root;
        }

        @Override
        public Iterator<UtilJSONPath> iterator() {
            return new Iterator<UtilJSONPath>(){
                final Iterator<JsonElement> it;
                {
                    this.it = Array.this.root.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public UtilJSONPath next() {
                    return new UtilJSONPath(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }
}

