/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.Actions;
import io.deepstream.AnonymousRecord;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamConfig;
import io.deepstream.DeepstreamError;
import io.deepstream.Event;
import io.deepstream.HasResult;
import io.deepstream.IConnection;
import io.deepstream.List;
import io.deepstream.ListenListener;
import io.deepstream.Message;
import io.deepstream.MessageBuilder;
import io.deepstream.MessageParser;
import io.deepstream.Record;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordSetResult;
import io.deepstream.SnapshotResult;
import io.deepstream.Topic;
import io.deepstream.UtilListener;
import io.deepstream.UtilSingleNotifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class RecordHandler {
    private final DeepstreamConfig deepstreamConfig;
    private final IConnection connection;
    private final DeepstreamClientAbstract client;
    private final Map<String, Record> records;
    private final Map<String, List> lists;
    private final UtilSingleNotifier hasRegistry;
    private final UtilSingleNotifier snapshotRegistry;
    private final Map<String, UtilListener> listeners;
    private final RecordHandlerListeners recordHandlerListeners;
    private final UtilSingleNotifier recordSetNotifier;

    @ObjectiveCName(value="init:connection:client:")
    RecordHandler(DeepstreamConfig deepstreamConfig, IConnection connection, DeepstreamClientAbstract client) {
        this.deepstreamConfig = deepstreamConfig;
        this.connection = connection;
        this.client = client;
        this.recordHandlerListeners = new RecordHandlerListeners();
        this.records = new HashMap<String, Record>();
        this.lists = new HashMap<String, List>();
        this.listeners = new HashMap<String, UtilListener>();
        this.hasRegistry = new UtilSingleNotifier(client, connection, Topic.RECORD, Actions.HAS, deepstreamConfig.getRecordReadTimeout());
        this.snapshotRegistry = new UtilSingleNotifier(client, connection, Topic.RECORD, Actions.SNAPSHOT, deepstreamConfig.getRecordReadTimeout());
        this.recordSetNotifier = new UtilSingleNotifier(client, connection, Topic.RECORD, Actions.PATCH, deepstreamConfig.getSubscriptionTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ObjectiveCName(value="getRecord:")
    public Record getRecord(String name) {
        Record record = this.records.get(name);
        if (record == null) {
            RecordHandler recordHandler = this;
            synchronized (recordHandler) {
                record = this.records.get(name);
                if (record == null) {
                    record = new Record(name, new HashMap(), this.connection, this.deepstreamConfig, this.client);
                    this.records.put(name, record);
                    record.addRecordEventsListener(this.recordHandlerListeners);
                    record.addRecordDestroyPendingListener(this.recordHandlerListeners);
                    record.start();
                }
            }
        }
        record.incrementUsage();
        if (!record.isReady()) {
            final CountDownLatch readyLatch = new CountDownLatch(1);
            record.whenReady(new Record.RecordReadyListener(){

                @Override
                public void onRecordReady(String recordName, Record record) {
                    readyLatch.countDown();
                }
            });
            try {
                readyLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return record;
    }

    @ObjectiveCName(value="getList:")
    public List getList(String name) {
        List list = this.lists.get(name);
        if (list == null) {
            list = new List(this, name);
            this.lists.put(name, list);
        }
        return list;
    }

    public AnonymousRecord getAnonymousRecord() {
        return new AnonymousRecord(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ObjectiveCName(value="listen:listenCallback:")
    public void listen(String pattern, ListenListener listenCallback) {
        if (this.listeners.containsKey(pattern)) {
            this.client.onError(Topic.RECORD, Event.LISTENER_EXISTS, pattern);
        } else {
            RecordHandler recordHandler = this;
            synchronized (recordHandler) {
                UtilListener utilListener = new UtilListener(Topic.RECORD, pattern, listenCallback, this.deepstreamConfig, this.client, this.connection);
                this.listeners.put(pattern, utilListener);
                utilListener.start();
            }
        }
    }

    @ObjectiveCName(value="unlisten:")
    public void unlisten(String pattern) {
        UtilListener listener = this.listeners.get(pattern);
        if (listener != null) {
            listener.destroy();
            this.listeners.remove(pattern);
        } else {
            this.client.onError(Topic.RECORD, Event.NOT_LISTENING, pattern);
        }
    }

    @ObjectiveCName(value="snapshot:")
    public SnapshotResult snapshot(String name) {
        final JsonElement[] data = new JsonElement[1];
        final DeepstreamError[] deepstreamException = new DeepstreamError[1];
        Record record = this.records.get(name);
        if (record != null && record.isReady()) {
            data[0] = record.get();
        } else {
            final CountDownLatch snapshotLatch = new CountDownLatch(1);
            this.snapshotRegistry.request(name, new UtilSingleNotifier.UtilSingleNotifierCallback(){

                @Override
                @ObjectiveCName(value="onSingleNotifierError:error:")
                public void onSingleNotifierError(String name, DeepstreamError error) {
                    deepstreamException[0] = error;
                    snapshotLatch.countDown();
                }

                @Override
                @ObjectiveCName(value="onSingleNotifierResponse:recordData:")
                public void onSingleNotifierResponse(String name, Object recordData) {
                    data[0] = (JsonElement)recordData;
                    snapshotLatch.countDown();
                }
            });
            try {
                snapshotLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return new SnapshotResult(data[0], deepstreamException[0]);
    }

    @ObjectiveCName(value="setData:data:")
    public RecordHandler setData(String recordName, Object data) {
        return this.setData(recordName, -1, null, data);
    }

    @ObjectiveCName(value="setData:path:data:")
    public RecordHandler setData(String recordName, String path, Object data) {
        return this.setData(recordName, -1, path, data);
    }

    @ObjectiveCName(value="setData:version:path:data:")
    public RecordHandler setData(String recordName, int version, String path, Object value) {
        Object element = value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : this.deepstreamConfig.getJsonParser().toJsonTree(value)));
        Record record = this.records.get(recordName);
        if (record != null) {
            if (path != null) {
                record.set(path, value);
            } else {
                record.set((JsonElement)element);
            }
            return this;
        }
        JsonObject config = new JsonObject();
        String remoteMessage = path == null ? MessageBuilder.getMsg(Topic.RECORD, Actions.CREATEANDUPDATE, new String[]{recordName, String.valueOf(version), element.toString(), config.toString()}) : MessageBuilder.getMsg(Topic.RECORD, Actions.CREATEANDUPDATE, new String[]{recordName, String.valueOf(version), path, MessageBuilder.typed(element), config.toString()});
        this.connection.send(remoteMessage);
        return this;
    }

    @ObjectiveCName(value="setDataWithAck:value:")
    public RecordSetResult setDataWithAck(String recordName, Object value) {
        return this.setDataWithAck(recordName, null, -1, value);
    }

    @ObjectiveCName(value="setDataWithAck:path:value:")
    public RecordSetResult setDataWithAck(String recordName, String path, Object value) {
        return this.setDataWithAck(recordName, path, -1, value);
    }

    @ObjectiveCName(value="setDataWithAck:path:version:value:")
    public RecordSetResult setDataWithAck(String recordName, String path, int version, Object value) {
        Record record = this.records.get(recordName);
        if (record != null) {
            if (path != null) {
                return record.setWithAck(path, value);
            }
            return record.setWithAck(this.deepstreamConfig.getJsonParser().toJsonTree(value));
        }
        Object element = value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : this.deepstreamConfig.getJsonParser().toJsonTree(value)));
        JsonObject config = new JsonObject();
        config.addProperty("writeSuccess", Boolean.valueOf(true));
        String[] data = path == null ? new String[]{recordName, String.valueOf(version), element.toString(), config.toString()} : new String[]{recordName, String.valueOf(version), path, MessageBuilder.typed(value), config.toString()};
        final RecordSetResult[] result = new RecordSetResult[1];
        final CountDownLatch snapshotLatch = new CountDownLatch(1);
        this.recordSetNotifier.request(String.valueOf(version), Actions.CREATEANDUPDATE, data, new UtilSingleNotifier.UtilSingleNotifierCallback(){

            @Override
            public void onSingleNotifierError(String name, DeepstreamError error) {
                result[0] = new RecordSetResult(error.getMessage());
                snapshotLatch.countDown();
            }

            @Override
            public void onSingleNotifierResponse(String name, Object data) {
                result[0] = new RecordSetResult(null);
                snapshotLatch.countDown();
            }
        });
        try {
            snapshotLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    @ObjectiveCName(value="has:")
    public HasResult has(String name) {
        final DeepstreamError[] deepstreamException = new DeepstreamError[1];
        final boolean[] hasRecord = new boolean[1];
        Record record = this.records.get(name);
        if (record != null && record.isReady()) {
            hasRecord[0] = true;
        } else {
            final CountDownLatch hasLatch = new CountDownLatch(1);
            this.hasRegistry.request(name, new UtilSingleNotifier.UtilSingleNotifierCallback(){

                @Override
                @ObjectiveCName(value="onSingleNotifierError:error:")
                public void onSingleNotifierError(String name, DeepstreamError error) {
                    deepstreamException[0] = error;
                    hasLatch.countDown();
                }

                @Override
                @ObjectiveCName(value="onSingleNotifierResponse:data:")
                public void onSingleNotifierResponse(String name, Object data) {
                    hasRecord[0] = (Boolean)data;
                    hasLatch.countDown();
                }
            });
            try {
                hasLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return new HasResult(hasRecord[0], deepstreamException[0]);
    }

    @ObjectiveCName(value="handle:")
    protected void handle(Message message) {
        UtilListener listener;
        Record record;
        String recordName;
        boolean processed = false;
        if (this.isUnhandledError(message).booleanValue()) {
            this.client.onError(Topic.RECORD, Event.getEvent(message.data[0]), message.data[1]);
            return;
        }
        if (message.action == Actions.ACK || message.action == Actions.ERROR) {
            recordName = message.data[1];
            if (this.isDiscardAck(message)) {
                Record record2 = this.records.get(recordName);
                if (Actions.getAction(message.data[0]) == Actions.DELETE && record2 != null) {
                    record2.onMessage(message);
                }
                return;
            }
            if (message.data[0].equals(Actions.SNAPSHOT.toString())) {
                this.snapshotRegistry.recieve(recordName, new DeepstreamError(message.data[2]), null);
                return;
            }
            if (message.data[0].equals(Actions.HAS.toString())) {
                this.hasRegistry.recieve(recordName, new DeepstreamError(message.data[2]), null);
                return;
            }
        } else {
            recordName = message.data[0];
        }
        if ((record = this.records.get(recordName)) != null) {
            processed = true;
            record.onMessage(message);
        }
        if (message.action == Actions.READ && this.snapshotRegistry.hasRequest(recordName)) {
            processed = true;
            this.snapshotRegistry.recieve(recordName, null, MessageParser.parseObject(message.data[2], this.deepstreamConfig.getJsonParser()));
        }
        if (message.action == Actions.HAS && this.hasRegistry.hasRequest(recordName)) {
            processed = true;
            this.hasRegistry.recieve(recordName, null, MessageParser.convertTyped(message.data[1], this.client, this.deepstreamConfig.getJsonParser()));
        }
        if (message.action == Actions.WRITE_ACKNOWLEDGEMENT) {
            processed = true;
            String val = String.valueOf(message.data[1]);
            Object versions = this.deepstreamConfig.getJsonParser().fromJson(val, JsonArray.class);
            Object error = MessageParser.convertTyped(message.data[2], this.client, this.deepstreamConfig.getJsonParser());
            if (error != null) {
                this.recordSetNotifier.recieve((JsonArray)versions, new DeepstreamError((String)error));
            } else {
                this.recordSetNotifier.recieve((JsonArray)versions, null);
            }
        }
        if ((listener = this.listeners.get(recordName)) != null) {
            processed = true;
            listener.onMessage(message);
        }
        if (!processed) {
            this.client.onError(Topic.RECORD, Event.UNSOLICITED_MESSAGE, String.format("%s %s", new Object[]{message.action, recordName}));
        }
    }

    @ObjectiveCName(value="isDiscardAck:")
    private boolean isDiscardAck(Message message) {
        Event event = Event.getEvent(message.data[0]);
        if (event == Event.MESSAGE_DENIED && Actions.getAction(message.data[2]) == Actions.DELETE) {
            return true;
        }
        Actions action = Actions.getAction(message.data[0]);
        return action == Actions.DELETE || action == Actions.UNSUBSCRIBE;
    }

    @ObjectiveCName(value="isUnhandledError:")
    private Boolean isUnhandledError(Message message) {
        if (message.action != Actions.ERROR) {
            return false;
        }
        String errorType = message.data[0];
        return !errorType.equals(Event.VERSION_EXISTS.toString()) && !errorType.equals(Event.MESSAGE_DENIED.toString()) && !errorType.equals(Actions.SNAPSHOT.toString()) && !errorType.equals(Actions.HAS.toString());
    }

    private class RecordHandlerListeners
    implements RecordEventsListener,
    Record.RecordDestroyPendingListener {
        RecordHandlerListeners() {
        }

        @Override
        @ObjectiveCName(value="onError:errorType:errorMessage:")
        public void onError(String recordName, Event errorType, String errorMessage) {
            RecordHandler.this.client.onError(Topic.RECORD, errorType, recordName + ":" + errorMessage);
        }

        @Override
        @ObjectiveCName(value="onRecordHasProviderChanged:hasProvider:")
        public void onRecordHasProviderChanged(String recordName, boolean hasProvider) {
        }

        @Override
        @ObjectiveCName(value="onDestroyPending:")
        public void onDestroyPending(String recordName) {
            this.onRecordDiscarded(recordName);
        }

        @Override
        @ObjectiveCName(value="onRecordDeleted:")
        public void onRecordDeleted(String recordName) {
            this.onRecordDiscarded(recordName);
        }

        @Override
        @ObjectiveCName(value="onRecordDiscarded:")
        public void onRecordDiscarded(String recordName) {
            RecordHandler.this.records.remove(recordName);
            RecordHandler.this.lists.remove(recordName);
        }
    }
}

