/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.Actions;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamError;
import io.deepstream.Event;
import io.deepstream.IConnection;
import io.deepstream.MessageBuilder;
import io.deepstream.Topic;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilResubscribeNotifier;
import io.deepstream.UtilTimeoutListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class UtilSingleNotifier
implements UtilResubscribeNotifier.UtilResubscribeListener,
UtilTimeoutListener {
    private final Topic topic;
    private final Actions action;
    private final int timeoutDuration;
    private final IConnection connection;
    private final Map<String, ArrayList<UtilSingleNotifierCallback>> requests;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;

    @ObjectiveCName(value="init:connection:topic:action:timeoutDuration:")
    public UtilSingleNotifier(DeepstreamClientAbstract client, IConnection connection, Topic topic, Actions action, int timeoutDuration) {
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        this.connection = connection;
        this.topic = topic;
        this.action = action;
        this.timeoutDuration = timeoutDuration;
        new UtilResubscribeNotifier(client, this);
        this.requests = new ConcurrentHashMap<String, ArrayList<UtilSingleNotifierCallback>>();
    }

    @ObjectiveCName(value="hasRequest:")
    public boolean hasRequest(String name) {
        return this.requests.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ObjectiveCName(value="request:utilSingleNotifierCallback:")
    public void request(String name, UtilSingleNotifierCallback utilSingleNotifierCallback) {
        ArrayList<UtilSingleNotifierCallback> callbacks = this.requests.get(name);
        if (callbacks == null) {
            UtilSingleNotifier utilSingleNotifier = this;
            synchronized (utilSingleNotifier) {
                callbacks = new ArrayList();
                this.requests.put(name, callbacks);
                this.send(name);
            }
        }
        callbacks.add(utilSingleNotifierCallback);
        this.ackTimeoutRegistry.add(this.topic, this.action, name, Event.RESPONSE_TIMEOUT, this, this.timeoutDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(String name, Actions action, String[] data, UtilSingleNotifierCallback utilSingleNotifierCallback) {
        ArrayList<UtilSingleNotifierCallback> callbacks = this.requests.get(name);
        if (callbacks == null) {
            UtilSingleNotifier utilSingleNotifier = this;
            synchronized (utilSingleNotifier) {
                callbacks = new ArrayList();
                this.requests.put(name, callbacks);
                this.send(action, data);
            }
        }
        callbacks.add(utilSingleNotifierCallback);
    }

    @ObjectiveCName(value="recieve:error:data:")
    public void recieve(String name, DeepstreamError error, Object data) {
        ArrayList<UtilSingleNotifierCallback> callbacks = this.requests.get(name);
        for (UtilSingleNotifierCallback callback : callbacks) {
            this.ackTimeoutRegistry.clear(this.topic, this.action, name);
            if (error != null) {
                callback.onSingleNotifierError(name, error);
                continue;
            }
            callback.onSingleNotifierResponse(name, data);
        }
        this.requests.remove(name);
    }

    public void recieve(JsonArray data, DeepstreamError error) {
        for (JsonElement version : data) {
            ArrayList<UtilSingleNotifierCallback> callbacks = this.requests.get(version.getAsString());
            UtilSingleNotifierCallback cb = callbacks.get(0);
            if (error != null) {
                cb.onSingleNotifierError(null, error);
                continue;
            }
            cb.onSingleNotifierResponse(null, null);
        }
    }

    @Override
    public void resubscribe() {
        for (String name : this.requests.keySet()) {
            this.send(name);
        }
    }

    @ObjectiveCName(value="send:")
    private void send(String name) {
        this.connection.send(MessageBuilder.getMsg(this.topic, this.action, name));
    }

    private void send(Actions action, String[] data) {
        this.connection.send(MessageBuilder.getMsg(this.topic, action, data));
    }

    @Override
    @ObjectiveCName(value="onTimeout:action:event:name:")
    public void onTimeout(Topic topic, Actions action, Event event, String name) {
        this.recieve(name, new DeepstreamError(String.format("Response for % timed out", name)), null);
    }

    static interface UtilSingleNotifierCallback {
        @ObjectiveCName(value="onSingleNotifierError:error:")
        public void onSingleNotifierError(String var1, DeepstreamError var2);

        @ObjectiveCName(value="onSingleNotifierResponse:data:")
        public void onSingleNotifierResponse(String var1, Object var2);
    }
}

