/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.Actions;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.Event;
import io.deepstream.Message;
import io.deepstream.Topic;
import io.deepstream.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MessageParser {
    private static final String MPS = Character.toString('\u001f');
    private static final String MS = Character.toString('\u001e');

    MessageParser() {
    }

    @ObjectiveCName(value="parse:client:")
    static List<Message> parse(String message, DeepstreamClientAbstract client) {
        String[] rawMessages;
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String rawMessage : rawMessages = message.split(MS)) {
            Message parsedMessage = MessageParser.parseMessage(rawMessage, client);
            if (parsedMessage == null) continue;
            messages.add(parsedMessage);
        }
        return messages;
    }

    @ObjectiveCName(value="parseMessage:client:")
    static Message parseMessage(String message, DeepstreamClientAbstract client) {
        String[] parts = message.split(MPS);
        if (parts.length < 2) {
            client.onError(null, Event.MESSAGE_PARSE_ERROR, "Insufficient message parts");
            return null;
        }
        if (Topic.getTopic(parts[0]) == null) {
            client.onError(null, Event.MESSAGE_PARSE_ERROR, "Received message for unknown topic " + parts[0]);
            return null;
        }
        if (Actions.getAction(parts[1]) == null) {
            client.onError(null, Event.MESSAGE_PARSE_ERROR, "Unknown action " + parts[1]);
            return null;
        }
        return new Message(message, Topic.getTopic(parts[0]), Actions.getAction(parts[1]), Arrays.copyOfRange(parts, 2, parts.length));
    }

    @ObjectiveCName(value="convertTyped:client:")
    static Object convertTyped(String value, DeepstreamClientAbstract client) {
        char type = value.charAt(0);
        if (Types.getType(type) == Types.STRING) {
            return value.substring(1);
        }
        if (Types.getType(type) == Types.NULL) {
            return null;
        }
        if (Types.getType(type) == Types.NUMBER) {
            return Float.valueOf(Float.parseFloat(value.substring(1)));
        }
        if (Types.getType(type) == Types.TRUE) {
            return true;
        }
        if (Types.getType(type) == Types.FALSE) {
            return false;
        }
        if (Types.getType(type) == Types.OBJECT) {
            return MessageParser.parseObject(value.substring(1));
        }
        if (Types.getType(type) == Types.UNDEFINED) {
            return Types.UNDEFINED;
        }
        client.onError(Topic.ERROR, Event.MESSAGE_PARSE_ERROR, "UNKNOWN_TYPE (" + value + ")");
        return null;
    }

    @ObjectiveCName(value="parseObject:")
    static Object parseObject(String value) {
        return new Gson().fromJson(value, JsonElement.class);
    }
}

