/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.Actions;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamConfig;
import io.deepstream.Event;
import io.deepstream.MessageParser;
import io.deepstream.RpcHandler;
import io.deepstream.Topic;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilTimeoutListener;

class Rpc
implements UtilTimeoutListener {
    private final String uid;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;
    private final DeepstreamConfig deepstreamConfig;
    private final DeepstreamClientAbstract client;
    private final RpcHandler.RpcResponseCallback callback;
    private final String rpcName;

    @ObjectiveCName(value="init:client:rpcName:uid:callback:")
    Rpc(DeepstreamConfig deepstreamConfig, DeepstreamClientAbstract client, String rpcName, String uid, RpcHandler.RpcResponseCallback callback) {
        this.deepstreamConfig = deepstreamConfig;
        this.client = client;
        this.rpcName = rpcName;
        this.uid = uid;
        this.callback = callback;
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        this.setTimeouts();
    }

    void ack() {
        this.ackTimeoutRegistry.clear(Topic.RPC, Actions.REQUEST, this.uid);
    }

    @ObjectiveCName(value="respond:data:")
    void respond(String rpcName, String data) {
        Object convertedData = MessageParser.convertTyped(data, this.client);
        this.callback.onRpcSuccess(rpcName, convertedData);
        this.clearTimeouts();
    }

    @ObjectiveCName(value="error:err:")
    void error(String rpcName, String err) {
        this.callback.onRpcError(rpcName, err);
        this.clearTimeouts();
    }

    @Override
    @ObjectiveCName(value="onTimeout:action:event:name:")
    public void onTimeout(Topic topic, Actions action, Event event, String name) {
        this.error(this.rpcName, event.toString());
    }

    private void clearTimeouts() {
        this.ackTimeoutRegistry.clear(Topic.RPC, Actions.REQUEST, this.uid);
        this.ackTimeoutRegistry.clear(Topic.RPC, Actions.RESPONSE, this.uid);
    }

    private void setTimeouts() {
        this.ackTimeoutRegistry.add(Topic.RPC, Actions.REQUEST, this.uid, Event.ACK_TIMEOUT, this.deepstreamConfig.getRpcAckTimeout());
        this.ackTimeoutRegistry.add(Topic.RPC, Actions.RESPONSE, this.uid, Event.RESPONSE_TIMEOUT, this, this.deepstreamConfig.getRpcResponseTimeout());
    }
}

