/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.Actions;
import io.deepstream.ConnectionState;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamConfig;
import io.deepstream.DeepstreamError;
import io.deepstream.DeepstreamRecordDestroyedException;
import io.deepstream.Event;
import io.deepstream.IConnection;
import io.deepstream.MergeStrategy;
import io.deepstream.Message;
import io.deepstream.MessageBuilder;
import io.deepstream.MessageParser;
import io.deepstream.RecordChangedCallback;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordMergeStrategies;
import io.deepstream.RecordMergeStrategy;
import io.deepstream.RecordMergeStrategyException;
import io.deepstream.RecordPathChangedCallback;
import io.deepstream.RecordSetResult;
import io.deepstream.Topic;
import io.deepstream.Types;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilEmitter;
import io.deepstream.UtilJSONPath;
import io.deepstream.UtilResubscribeNotifier;
import io.deepstream.UtilSingleNotifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class Record {
    private static final String ALL_EVENT = "ALL_EVENT";
    private static final String DESTROY_PENDING = "DESTROY_PENDING";
    private final UtilResubscribeNotifier utilResubscribeNotifier;
    private final UtilSingleNotifier recordSetNotifier;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;
    private final IConnection connection;
    private final DeepstreamClientAbstract client;
    private final Gson gson;
    private final UtilJSONPath path;
    private final UtilEmitter subscribers;
    private final ArrayList<RecordEventsListener> recordEventsListeners;
    private final ArrayList<RecordDestroyPendingListener> recordDestroyPendingListeners;
    private final ArrayList<RecordReadyListener> onceRecordReadyListeners;
    private final String name;
    private final DeepstreamConfig deepstreamConfig;
    private boolean isReady;
    private boolean isDestroyed;
    private int version;
    private int usages;
    private RecordMergeStrategy mergeStrategy;
    private RecordRemoteUpdateHandler recordRemoteUpdateHandler;
    private JsonElement data;
    private boolean hasProvider;

    @ObjectiveCName(value="init:recordOptions:connection:deepstreamConfig:client:")
    Record(String name, Map recordOptions, IConnection connection, DeepstreamConfig deepstreamConfig, DeepstreamClientAbstract client) {
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        this.name = name;
        this.deepstreamConfig = deepstreamConfig;
        this.usages = 0;
        this.version = -1;
        this.connection = connection;
        this.client = client;
        this.gson = new Gson();
        this.data = new JsonObject();
        this.path = new UtilJSONPath(this.data);
        this.subscribers = new UtilEmitter();
        this.isReady = false;
        this.isDestroyed = false;
        this.hasProvider = false;
        this.recordEventsListeners = new ArrayList();
        this.onceRecordReadyListeners = new ArrayList();
        this.recordDestroyPendingListeners = new ArrayList();
        this.utilResubscribeNotifier = new UtilResubscribeNotifier(client, new UtilResubscribeNotifier.UtilResubscribeListener(){

            @Override
            public void resubscribe() {
                Record.this.sendRead();
            }
        });
        this.recordSetNotifier = new UtilSingleNotifier(client, connection, Topic.RECORD, Actions.PATCH, deepstreamConfig.getSubscriptionTimeout());
    }

    void start() {
        this.scheduleAcks();
        this.sendRead();
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasProvider() {
        return this.hasProvider;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @ObjectiveCName(value="version")
    public int version() {
        return this.version;
    }

    public String name() {
        return this.name;
    }

    @ObjectiveCName(value="addRecordEventsListener:")
    public Record addRecordEventsListener(RecordEventsListener recordEventsListener) {
        this.recordEventsListeners.add(recordEventsListener);
        return this;
    }

    @ObjectiveCName(value="removeRecordEventsListener:")
    public Record removeRecordEventsListener(RecordEventsListener recordEventsListener) {
        this.recordEventsListeners.remove(recordEventsListener);
        return this;
    }

    @ObjectiveCName(value="setMergeStrategy:")
    public Record setMergeStrategy(MergeStrategy mergeStrategy) {
        this.mergeStrategy = RecordMergeStrategies.INSTANCE.getMergeStrategy(mergeStrategy);
        return this;
    }

    @ObjectiveCName(value="setCustomMergeStrategy:")
    public Record setMergeStrategy(RecordMergeStrategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    <T> T get(Class<T> type) {
        return this.deepCopy(this.data, type);
    }

    @ObjectiveCName(value="get:")
    public JsonElement get(String path) {
        return this.deepCopy(this.path.get(path));
    }

    public JsonElement get() {
        return this.deepCopy(this.data);
    }

    @ObjectiveCName(value="set:")
    public Record set(JsonElement value) throws DeepstreamRecordDestroyedException {
        return this.set(null, value, false);
    }

    @ObjectiveCName(value="set:value:")
    public Record set(String path, Object value) throws DeepstreamRecordDestroyedException {
        return this.set(path, value, false);
    }

    @ObjectiveCName(value="setWithAck:")
    public RecordSetResult setWithAck(Object value) {
        return this.setWithAck(null, value);
    }

    @ObjectiveCName(value="setWithAck:value:")
    public RecordSetResult setWithAck(String path, Object value) {
        this.throwExceptionIfDestroyed("set");
        Object element = value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : this.gson.toJsonTree(value)));
        JsonElement object = this.path.get(path);
        if (object != null && object.equals(value)) {
            return new RecordSetResult(null);
        }
        if (path == null && this.data.equals(value)) {
            return new RecordSetResult(null);
        }
        final RecordSetResult[] result = new RecordSetResult[1];
        final Map<String, JsonElement> oldValues = this.beginChange();
        this.path.set(path, (JsonElement)element);
        this.data = this.path.getCoreElement();
        JsonObject config = new JsonObject();
        config.addProperty("writeSuccess", Boolean.valueOf(true));
        String newVersion = String.valueOf(this.version + 1);
        String[] data = path == null ? new String[]{this.name(), newVersion, element.toString(), config.toString()} : new String[]{this.name(), newVersion, path, MessageBuilder.typed(value), config.toString()};
        final CountDownLatch snapshotLatch = new CountDownLatch(1);
        this.recordSetNotifier.request(newVersion, data, new UtilSingleNotifier.UtilSingleNotifierCallback(){

            @Override
            public void onSingleNotifierError(String name, DeepstreamError error) {
                result[0] = new RecordSetResult(error.getMessage());
                snapshotLatch.countDown();
            }

            @Override
            public void onSingleNotifierResponse(String name, Object data) {
                Record.this.completeChange(oldValues);
                result[0] = new RecordSetResult(null);
                snapshotLatch.countDown();
            }
        });
        try {
            snapshotLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    @ObjectiveCName(value="subscribe:recordPathChangedCallback:")
    public Record subscribe(String path, RecordPathChangedCallback recordPathChangedCallback) throws DeepstreamRecordDestroyedException {
        return this.subscribe(path, recordPathChangedCallback, false);
    }

    @ObjectiveCName(value="subscribe:recordPathChangedCallback:triggerNow:")
    public Record subscribe(String path, RecordPathChangedCallback recordPathChangedCallback, boolean triggerNow) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("subscribe");
        this.subscribers.on(path, (Object)recordPathChangedCallback);
        if (triggerNow) {
            recordPathChangedCallback.onRecordPathChanged(this.name, path, this.get(path));
        }
        return this;
    }

    @ObjectiveCName(value="subscribe:")
    public Record subscribe(RecordChangedCallback recordChangedCallback) throws DeepstreamRecordDestroyedException {
        return this.subscribe(recordChangedCallback, false);
    }

    @ObjectiveCName(value="subscribe:triggerNow:")
    public Record subscribe(RecordChangedCallback recordChangedCallback, boolean triggerNow) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("subscribe");
        this.subscribers.on(ALL_EVENT, (Object)recordChangedCallback);
        if (triggerNow) {
            recordChangedCallback.onRecordChanged(this.name, this.get());
        }
        return this;
    }

    @ObjectiveCName(value="unsubscribe:")
    public Record unsubscribe(RecordChangedCallback recordChangedCallback) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("unsubscribe");
        this.subscribers.off(ALL_EVENT, recordChangedCallback);
        return this;
    }

    @ObjectiveCName(value="unsubscribe:recordPathChangedCallback:")
    public Record unsubscribe(String path, RecordPathChangedCallback recordPathChangedCallback) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("unsubscribe");
        this.subscribers.off(path, recordPathChangedCallback);
        return this;
    }

    public Record discard() throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("discard");
        --this.usages;
        if (this.usages <= 0) {
            this.whenReady(new RecordReadyListener(){

                @Override
                public void onRecordReady(String recordName, Record record) {
                    Record.this.ackTimeoutRegistry.add(Topic.RECORD, Actions.UNSUBSCRIBE, Record.this.name, Record.this.deepstreamConfig.getSubscriptionTimeout());
                    Record.this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.UNSUBSCRIBE, Record.this.name));
                    for (RecordDestroyPendingListener recordDestroyPendingHandler : Record.this.recordDestroyPendingListeners) {
                        recordDestroyPendingHandler.onDestroyPending(Record.this.name);
                    }
                }
            });
        }
        return this;
    }

    @ObjectiveCName(value="delete")
    public Record delete() throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("delete");
        this.whenReady(new RecordReadyListener(){

            @Override
            public void onRecordReady(String recordName, Record record) {
                Record.this.ackTimeoutRegistry.add(Topic.RECORD, Actions.DELETE, Record.this.name, Event.DELETE_TIMEOUT, Record.this.deepstreamConfig.getSubscriptionTimeout());
                Record.this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.DELETE, Record.this.name));
                for (RecordDestroyPendingListener recordDestroyPendingHandler : Record.this.recordDestroyPendingListeners) {
                    recordDestroyPendingHandler.onDestroyPending(Record.this.name);
                }
            }
        });
        return this;
    }

    @ObjectiveCName(value="whenReady:")
    Record whenReady(RecordReadyListener recordReadyListener) {
        if (this.isReady) {
            recordReadyListener.onRecordReady(this.name, this);
        } else {
            this.onceRecordReadyListeners.add(recordReadyListener);
        }
        return this;
    }

    @ObjectiveCName(value="onMessage:")
    void onMessage(Message message) {
        if (message.action == Actions.ACK) {
            this.processAckMessage(message);
        } else if (message.action == Actions.READ && this.version() == -1) {
            this.onRead(message);
        } else if (message.action == Actions.READ || message.action == Actions.UPDATE || message.action == Actions.PATCH) {
            this.applyUpdate(message);
        } else if (message.action == Actions.WRITE_ACKNOWLEDGEMENT) {
            this.handleWriteAcknowledgement(message);
        } else if (message.action == Actions.SUBSCRIPTION_HAS_PROVIDER) {
            this.updateHasProvider(message);
        } else if (message.data[0].equals(Event.VERSION_EXISTS.toString())) {
            this.recoverRecord(Integer.parseInt(message.data[2]), (JsonElement)this.gson.fromJson(message.data[3], JsonElement.class));
        } else if (message.data[0].equals(Event.MESSAGE_DENIED.toString())) {
            this.clearTimeouts();
        }
    }

    private void handleWriteAcknowledgement(Message message) {
        String val = String.valueOf(message.data[1]);
        Object versions = this.gson.fromJson(val, JsonArray.class);
        Object error = MessageParser.convertTyped(message.data[2], this.client);
        if (error != null) {
            this.recordSetNotifier.recieve((JsonArray)versions, new DeepstreamError((String)error));
        } else {
            this.recordSetNotifier.recieve((JsonArray)versions, null);
        }
    }

    @ObjectiveCName(value="setRecordRemoteUpdateHandler:")
    void setRecordRemoteUpdateHandler(RecordRemoteUpdateHandler recordRemoteUpdateHandler) {
        this.recordRemoteUpdateHandler = recordRemoteUpdateHandler;
    }

    @ObjectiveCName(value="updateHasProvider:")
    private void updateHasProvider(Message message) {
        this.hasProvider = (Boolean)MessageParser.convertTyped(message.data[1], this.client);
        for (RecordEventsListener recordEventsListener : this.recordEventsListeners) {
            recordEventsListener.onRecordHasProviderChanged(this.name, this.hasProvider);
        }
    }

    @ObjectiveCName(value="applyUpdate:")
    private void applyUpdate(Message message) {
        JsonElement data;
        int newVersion = Integer.parseInt(message.data[1]);
        boolean delete = false;
        if (message.action == Actions.PATCH) {
            Object rawData = MessageParser.convertTyped(message.data[3], this.client);
            if (rawData == Types.UNDEFINED) {
                delete = true;
                data = null;
            } else {
                data = this.gson.toJsonTree(rawData);
            }
        } else {
            data = (JsonElement)this.gson.fromJson(message.data[2], JsonElement.class);
        }
        if (this.version != -1 && this.version + 1 != newVersion) {
            if (message.action == Actions.PATCH) {
                this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.SNAPSHOT, this.name));
            } else {
                this.recoverRecord(newVersion, data);
            }
            return;
        }
        if (this.recordRemoteUpdateHandler != null) {
            this.recordRemoteUpdateHandler.beforeRecordUpdate();
        }
        Map<String, JsonElement> oldValues = this.beginChange();
        this.version = newVersion;
        if (Actions.PATCH == message.action) {
            if (delete) {
                this.path.delete(message.data[2]);
            } else {
                this.path.set(message.data[2], data);
            }
        } else {
            this.data = data;
            this.path.setCoreElement(data);
        }
        this.completeChange(oldValues);
        if (this.recordRemoteUpdateHandler != null) {
            this.recordRemoteUpdateHandler.afterRecordUpdate();
        }
    }

    @ObjectiveCName(value="recoverRecord:remoteData:")
    private void recoverRecord(int remoteVersion, JsonElement remoteData) {
        try {
            JsonElement mergedData = this.mergeStrategy.merge(this, remoteData, remoteVersion);
            this.version = remoteVersion;
            this.set(null, mergedData, true);
        }
        catch (RecordMergeStrategyException ex) {
            this.client.onError(Topic.RECORD, Event.VERSION_EXISTS, "Received update for " + remoteVersion + " but version is " + this.version);
        }
    }

    private void scheduleAcks() {
        this.ackTimeoutRegistry.add(Topic.RECORD, Actions.SUBSCRIBE, this.name, Event.ACK_TIMEOUT, this.deepstreamConfig.getRecordReadAckTimeout());
        this.ackTimeoutRegistry.add(Topic.RECORD, Actions.READ, this.name, Event.RESPONSE_TIMEOUT, this.deepstreamConfig.getRecordReadTimeout());
    }

    private void clearTimeouts() {
        this.ackTimeoutRegistry.clear(Topic.RECORD, Actions.SUBSCRIBE, this.name);
        this.ackTimeoutRegistry.clear(Topic.RECORD, Actions.READ, this.name);
    }

    private Map<String, JsonElement> beginChange() {
        Set<String> paths = this.subscribers.getEvents();
        if (paths.isEmpty()) {
            return null;
        }
        HashMap<String, JsonElement> oldValues = new HashMap<String, JsonElement>();
        if (paths.contains(ALL_EVENT)) {
            oldValues.put(ALL_EVENT, this.get());
        }
        for (String path : paths) {
            if (path.equals(ALL_EVENT)) continue;
            oldValues.put(path, this.get(path));
        }
        return oldValues;
    }

    private void completeChange(Map<String, JsonElement> oldValues) {
        List<Object> listeners;
        if (oldValues == null || oldValues.isEmpty()) {
            return;
        }
        JsonElement oldValue = oldValues.remove(ALL_EVENT);
        if (oldValue != null && !oldValue.equals(this.data)) {
            listeners = this.subscribers.listeners(ALL_EVENT);
            for (Object listener : listeners) {
                ((RecordChangedCallback)listener).onRecordChanged(this.name, this.get());
            }
        }
        for (String key : oldValues.keySet()) {
            oldValue = oldValues.get(key);
            JsonElement newValue = this.get(key);
            if (oldValue != null && oldValue.equals(newValue)) continue;
            listeners = this.subscribers.listeners(key);
            for (Object listener : listeners) {
                if (!(listener instanceof RecordPathChangedCallback)) continue;
                ((RecordPathChangedCallback)listener).onRecordPathChanged(this.name, key, newValue);
            }
        }
    }

    private void throwExceptionIfDestroyed(String method) throws DeepstreamRecordDestroyedException {
        if (this.isDestroyed) {
            throw new DeepstreamRecordDestroyedException(method);
        }
    }

    @ObjectiveCName(value="processAckMessage:")
    private void processAckMessage(Message message) {
        Actions action = Actions.getAction(message.data[0]);
        this.ackTimeoutRegistry.clear(message);
        if (action.equals((Object)Actions.DELETE)) {
            for (RecordEventsListener recordEventsListener : this.recordEventsListeners) {
                recordEventsListener.onRecordDeleted(this.name);
            }
            this.destroy();
        } else if (action.equals((Object)Actions.UNSUBSCRIBE)) {
            for (RecordEventsListener recordEventsListener : this.recordEventsListeners) {
                recordEventsListener.onRecordDiscarded(this.name);
            }
            this.destroy();
        }
    }

    @ObjectiveCName(value="onRead:")
    private void onRead(Message message) {
        this.ackTimeoutRegistry.clear(message);
        Map<String, JsonElement> oldValues = this.beginChange();
        this.version = Integer.parseInt(message.data[1]);
        this.data = (JsonElement)this.gson.fromJson(message.data[2], JsonElement.class);
        this.path.setCoreElement(this.data);
        this.completeChange(oldValues);
        this.setReady();
    }

    private void setReady() {
        this.isReady = true;
        for (RecordReadyListener recordReadyListener : this.onceRecordReadyListeners) {
            recordReadyListener.onRecordReady(this.name, this);
        }
        this.onceRecordReadyListeners.clear();
    }

    private void sendRead() {
        if (this.client.getConnectionState() == ConnectionState.OPEN) {
            this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.CREATEORREAD, this.name));
        }
    }

    @ObjectiveCName(value="sendUpdate:value:")
    private void sendUpdate(String key, Object value) {
        ++this.version;
        if (key == null || key.equals("")) {
            this.connection.sendMsg(Topic.RECORD, Actions.UPDATE, new String[]{this.name, String.valueOf(this.version), this.gson.toJson(value)});
        } else {
            this.connection.sendMsg(Topic.RECORD, Actions.PATCH, new String[]{this.name, String.valueOf(this.version), key, MessageBuilder.typed(value)});
        }
    }

    private void destroy() {
        this.clearTimeouts();
        this.utilResubscribeNotifier.destroy();
        this.isReady = false;
        this.isDestroyed = true;
    }

    @ObjectiveCName(value="deepCopy:")
    private JsonElement deepCopy(JsonElement element) {
        try {
            return (JsonElement)this.gson.fromJson(this.gson.toJson((Object)element, JsonElement.class), JsonElement.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> T deepCopy(JsonElement element, Class<T> type) {
        return (T)this.gson.fromJson(this.gson.toJson((Object)element, JsonElement.class), type);
    }

    @ObjectiveCName(value="set:value:force:")
    private Record set(String path, Object value, boolean force) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("set");
        Object element = value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : this.gson.toJsonTree(value)));
        JsonElement object = this.path.get(path);
        if (!force) {
            if (object != null && object.equals(value)) {
                return this;
            }
            if (path == null && this.data.equals(value)) {
                return this;
            }
        }
        Map<String, JsonElement> oldValues = this.beginChange();
        this.path.set(path, (JsonElement)element);
        this.data = this.path.getCoreElement();
        this.sendUpdate(path, value);
        this.completeChange(oldValues);
        return this;
    }

    @ObjectiveCName(value="addRecordDestroyPendingListener:")
    void addRecordDestroyPendingListener(RecordDestroyPendingListener recordDestroyPendingListener) {
        this.recordDestroyPendingListeners.add(recordDestroyPendingListener);
    }

    void incrementUsage() {
        ++this.usages;
    }

    @ObjectiveCName(value="RecordReadyListener")
    static interface RecordReadyListener {
        @ObjectiveCName(value="onRecordReady:record:")
        public void onRecordReady(String var1, Record var2);
    }

    @ObjectiveCName(value="RecordDestroyPendingListener")
    static interface RecordDestroyPendingListener {
        @ObjectiveCName(value="onDestroyPending:")
        public void onDestroyPending(String var1);
    }

    @ObjectiveCName(value="RecordRemoteUpdateHandler")
    static interface RecordRemoteUpdateHandler {
        @ObjectiveCName(value="beforeRecordUpdate")
        public void beforeRecordUpdate();

        @ObjectiveCName(value="afterRecordUpdate")
        public void afterRecordUpdate();
    }
}

