/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.Connection;
import io.deepstream.DeepstreamConfig;
import io.deepstream.Endpoint;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.handshake.ServerHandshake;

class EndpointWebsocket
implements Endpoint {
    private final URI originalURI;
    private WebSocket websocket;
    private final Connection connection;

    EndpointWebsocket(String url, DeepstreamConfig deepstreamConfig, Connection connection) throws URISyntaxException {
        this.originalURI = this.parseUri(url, deepstreamConfig.getPath());
        this.connection = connection;
    }

    private URI parseUri(String url, String defaultPath) throws URISyntaxException {
        if (url.startsWith("http:") || url.startsWith("https:")) {
            throw new URISyntaxException(url, "HTTP/HTTPS is not supported, please use ws or wss instead");
        }
        if (url.startsWith("//")) {
            url = "ws:" + url;
        } else if (!url.startsWith("ws:") && !url.startsWith("wss:")) {
            url = "ws://" + url;
        }
        URI uri = new URI(url);
        if (uri.getPath().isEmpty()) {
            uri = uri.resolve(defaultPath);
        }
        return uri;
    }

    @Override
    public void send(String message) {
        this.websocket.send(message);
    }

    @Override
    public void close() {
        this.websocket.close();
        this.websocket = null;
    }

    @Override
    public void forceClose() {
        this.websocket.getConnection().closeConnection(1, "Forcing connection close due to network loss");
    }

    @Override
    public void open() {
        this.websocket = new WebSocket(this.originalURI, (Draft)new Draft_10());
        this.websocket.connect();
    }

    private class WebSocket
    extends WebSocketClient {
        WebSocket(URI serverUri, Draft draft) {
            super(serverUri, draft);
            if (serverUri.toString().startsWith("wss:")) {
                SSLContext sslContext;
                try {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, null, null);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                this.setWebSocketFactory((WebSocketClient.WebSocketClientFactory)new DefaultSSLWebSocketClientFactory(sslContext));
            }
        }

        public void onOpen(ServerHandshake handshakedata) {
            EndpointWebsocket.this.connection.onOpen();
        }

        public void onMessage(String message) {
            EndpointWebsocket.this.connection.onMessage(message);
        }

        public void onClose(int code, String reason, boolean remote) {
            try {
                EndpointWebsocket.this.connection.onClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onError(Exception ex) {
            EndpointWebsocket.this.connection.onError(ex.getMessage());
        }
    }
}

