/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.ConnectionState;
import io.deepstream.ConnectionStateListener;
import io.deepstream.DeepstreamClientAbstract;

class UtilResubscribeNotifier
implements ConnectionStateListener {
    private DeepstreamClientAbstract client;
    private UtilResubscribeListener resubscribe;
    private boolean isReconnecting;

    @ObjectiveCName(value="init:callback:")
    public UtilResubscribeNotifier(DeepstreamClientAbstract client, UtilResubscribeListener callback) {
        this.client = client;
        this.resubscribe = callback;
        this.isReconnecting = false;
        this.client.addConnectionChangeListener(this);
    }

    void destroy() {
        this.client.removeConnectionChangeListener(this);
        this.client = null;
        this.resubscribe = null;
    }

    @Override
    @ObjectiveCName(value="connectionStateChanged:")
    public void connectionStateChanged(ConnectionState state) {
        if (state == ConnectionState.RECONNECTING && !this.isReconnecting) {
            this.isReconnecting = true;
        }
        if (state == ConnectionState.OPEN && this.isReconnecting) {
            this.isReconnecting = false;
            this.resubscribe.resubscribe();
        }
    }

    static interface UtilResubscribeListener {
        public void resubscribe();
    }
}

