/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.ListChangedListener;
import io.deepstream.ListEntryChangedListener;
import io.deepstream.Record;
import io.deepstream.RecordChangedCallback;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class List {
    private final RecordListeners recordListeners;
    private final Record record;
    private final ArrayList<ListChangedListener> listChangedListeners;
    private final ArrayList<ListEntryChangedListener> listEntryChangedListeners;

    @ObjectiveCName(value="init:name:")
    List(RecordHandler recordHandler, String name) {
        this.record = recordHandler.getRecord(name);
        this.recordListeners = new RecordListeners(this, this.record);
        this.listChangedListeners = new ArrayList();
        this.listEntryChangedListeners = new ArrayList();
    }

    public boolean isReady() {
        return this.record.isReady();
    }

    public boolean isDestroyed() {
        return this.record.isDestroyed();
    }

    public int version() {
        return this.record.version();
    }

    public String name() {
        return this.record.name();
    }

    @ObjectiveCName(value="addRecordEventsListener:")
    public List addRecordEventsListener(RecordEventsListener recordEventsListener) {
        this.record.addRecordEventsListener(recordEventsListener);
        return this;
    }

    @ObjectiveCName(value="removeRecordEventsListener:")
    public List removeRecordEventsListener(RecordEventsListener recordEventsListener) {
        this.record.removeRecordEventsListener(recordEventsListener);
        return this;
    }

    public java.util.List<String> getEntries() {
        ArrayList<String> entries;
        try {
            entries = this.record.get(java.util.List.class);
        }
        catch (Exception ex) {
            entries = new ArrayList<String>();
        }
        return entries;
    }

    @ObjectiveCName(value="setEntries:")
    public List setEntries(java.util.List<String> entries) {
        this.updateList(entries);
        return this;
    }

    @ObjectiveCName(value="removeEntry:")
    public List removeEntry(String entry) {
        java.util.List<String> entries = this.getEntries();
        while (entries.contains(entry)) {
            entries.remove(entry);
        }
        this.updateList(entries);
        return this;
    }

    @ObjectiveCName(value="removeEntry:index:")
    public List removeEntry(String entry, int index) {
        java.util.List<String> entries = this.getEntries();
        if (entries.get(index).equals(entry)) {
            entries.remove(index);
        }
        this.updateList(entries);
        return this;
    }

    @ObjectiveCName(value="addEntry:")
    public List addEntry(String entry) {
        java.util.List<String> entries = this.getEntries();
        entries.add(entry);
        this.updateList(entries);
        return this;
    }

    @ObjectiveCName(value="addEntry:index:")
    public List addEntry(String entry, int index) {
        java.util.List<String> entries = this.getEntries();
        entries.add(index, entry);
        this.updateList(entries);
        return this;
    }

    public List discard() {
        this.record.discard();
        return this;
    }

    public boolean isEmpty() {
        return this.getEntries().size() == 0;
    }

    @ObjectiveCName(value="subscribe:")
    public List subscribe(ListChangedListener listChangedListener) {
        return this.subscribe(listChangedListener, false);
    }

    @ObjectiveCName(value="subscribe:triggerNow:")
    public List subscribe(ListChangedListener listChangedListener, boolean triggerNow) {
        this.listChangedListeners.add(listChangedListener);
        if (this.listChangedListeners.size() == 1) {
            this.record.subscribe(this.recordListeners);
        }
        if (triggerNow) {
            for (ListChangedListener listChangeListener : this.listChangedListeners) {
                listChangeListener.onListChanged(this.name(), this.getEntries());
            }
        }
        return this;
    }

    @ObjectiveCName(value="unsubscribe:")
    public List unsubscribe(ListChangedListener listChangedListener) {
        this.listChangedListeners.remove(listChangedListener);
        if (this.listChangedListeners.size() == 0) {
            this.record.unsubscribe(this.recordListeners);
        }
        return this;
    }

    @ObjectiveCName(value="subscribeWithListEntryChangedListener:")
    public List subscribe(ListEntryChangedListener listEntryChangedListener) {
        this.listEntryChangedListeners.add(listEntryChangedListener);
        if (this.listEntryChangedListeners.size() == 0) {
            this.record.subscribe(this.recordListeners);
        }
        return this;
    }

    @ObjectiveCName(value="unsubscribeWithListEntryChangedListener:")
    public List unsubscribe(ListEntryChangedListener listEntryChangedListener) {
        this.listEntryChangedListeners.remove(listEntryChangedListener);
        if (this.listEntryChangedListeners.size() == 0) {
            this.record.unsubscribe(this.recordListeners);
        }
        return this;
    }

    Record getUnderlyingRecord() {
        return this.record;
    }

    @ObjectiveCName(value="updateList:")
    private void updateList(Collection entries) {
        Map<String, ArrayList<Integer>> oldStructure = this.beforeChange();
        this.record.set(entries);
        this.afterChange(oldStructure);
    }

    private Map<String, ArrayList<Integer>> beforeChange() {
        if (this.listChangedListeners.isEmpty()) {
            return null;
        }
        return this.getStructure();
    }

    @ObjectiveCName(value="afterChange:")
    private void afterChange(Map<String, ArrayList<Integer>> oldStructure) {
        ArrayList<Integer> newIndexes;
        ArrayList<Integer> oldIndexes;
        if (oldStructure == null) {
            return;
        }
        Map<String, ArrayList<Integer>> newStructure = this.getStructure();
        for (String entryName : oldStructure.keySet()) {
            oldIndexes = oldStructure.get(entryName);
            newIndexes = newStructure.get(entryName);
            for (Integer index : oldIndexes) {
                if (newIndexes != null) continue;
                for (ListEntryChangedListener listEntryChangedListener : this.listEntryChangedListeners) {
                    listEntryChangedListener.onEntryRemoved(this.name(), entryName, index);
                }
            }
        }
        for (String entryName : newStructure.keySet()) {
            oldIndexes = oldStructure.get(entryName);
            newIndexes = newStructure.get(entryName);
            if (oldIndexes == null) {
                for (Integer index : newIndexes) {
                    for (ListEntryChangedListener listEntryChangedListener : this.listEntryChangedListeners) {
                        listEntryChangedListener.onEntryAdded(this.name(), entryName, index);
                    }
                }
                continue;
            }
            for (int i = 0; i < newIndexes.size(); ++i) {
                Integer index;
                index = newIndexes.get(i);
                if (oldIndexes.size() >= i && oldIndexes.get(i).equals(newIndexes.get(i))) continue;
                if (oldIndexes.size() < i) {
                    for (ListEntryChangedListener listEntryChangedListener : this.listEntryChangedListeners) {
                        listEntryChangedListener.onEntryAdded(this.name(), entryName, index);
                    }
                    continue;
                }
                for (ListEntryChangedListener listEntryChangedListener : this.listEntryChangedListeners) {
                    listEntryChangedListener.onEntryMoved(this.name(), entryName, index);
                }
            }
        }
    }

    private Map<String, ArrayList<Integer>> getStructure() {
        HashMap<String, ArrayList<Integer>> structure = new HashMap<String, ArrayList<Integer>>();
        java.util.List<String> entries = this.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ArrayList<Integer> list = (ArrayList<Integer>)structure.get(entries.get(i));
            if (list == null) {
                list = new ArrayList<Integer>();
                structure.put(entries.get(i), list);
            }
            list.add(i);
        }
        return structure;
    }

    private class RecordListeners
    implements RecordChangedCallback,
    Record.RecordRemoteUpdateHandler {
        private final List list;
        private final Record record;
        private Map<String, ArrayList<Integer>> beforeChange;

        @ObjectiveCName(value="init:record:")
        RecordListeners(List list2, Record record) {
            this.list = list2;
            this.record = record;
            this.record.setRecordRemoteUpdateHandler(this);
        }

        @Override
        @ObjectiveCName(value="onRecordChanged:data:")
        public void onRecordChanged(String recordName, JsonElement data) {
            for (ListChangedListener listChangeListener : this.list.listChangedListeners) {
                listChangeListener.onListChanged(this.list.name(), this.list.getEntries());
            }
        }

        @Override
        public void beforeRecordUpdate() {
            this.beforeChange = this.list.beforeChange();
        }

        @Override
        public void afterRecordUpdate() {
            this.list.afterChange(this.beforeChange);
        }
    }
}

