/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.Connection;
import io.deepstream.DeepstreamConfig;
import io.deepstream.Endpoint;
import java.net.URI;
import java.net.URISyntaxException;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.handshake.ServerHandshake;

class EndpointWebsocket
implements Endpoint {
    private final URI originalURI;
    private WebSocket websocket;
    private final Connection connection;

    EndpointWebsocket(String url, DeepstreamConfig deepstreamConfig, Connection connection) throws URISyntaxException {
        this.originalURI = this.parseUri(url, deepstreamConfig.getPath());
        this.connection = connection;
    }

    private URI parseUri(String url, String defaultPath) throws URISyntaxException {
        if (url.matches("^http:|^https:")) {
            throw new URISyntaxException(url, "HTTP/HTTPS is not supported, please use ws or wss instead");
        }
        if (url.matches("^//")) {
            url = "ws:" + url;
        } else if (!url.matches("^ws:|^wss:")) {
            url = "ws://" + url;
        }
        URI uri = new URI(url);
        if (uri.getPath().equals("")) {
            uri = uri.resolve(defaultPath);
        }
        return uri;
    }

    @Override
    public void send(String message) {
        this.websocket.send(message);
    }

    @Override
    public void close() {
        this.websocket.close();
    }

    @Override
    public void open() {
        this.websocket = new WebSocket(this.originalURI, (Draft)new Draft_10());
        this.websocket.connect();
    }

    private class WebSocket
    extends WebSocketClient {
        WebSocket(URI serverUri, Draft draft) {
            super(serverUri, draft);
        }

        public void onOpen(ServerHandshake handshakedata) {
            EndpointWebsocket.this.connection.onOpen();
        }

        public void onMessage(String message) {
            EndpointWebsocket.this.connection.onMessage(message);
        }

        public void onClose(int code, String reason, boolean remote) {
            try {
                EndpointWebsocket.this.connection.onClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onError(Exception ex) {
            EndpointWebsocket.this.connection.onError(ex.getMessage());
        }
    }
}

