/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.j2objc.annotations.ObjectiveCName;
import io.deepstream.ConnectionState;
import io.deepstream.DeepstreamClient;
import io.deepstream.InvalidDeepstreamConfig;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DeepstreamFactory {
    private static DeepstreamFactory ourInstance = new DeepstreamFactory();
    Map<String, DeepstreamClient> clients = new HashMap<String, DeepstreamClient>();

    private DeepstreamFactory() {
    }

    public static DeepstreamFactory getInstance() {
        return ourInstance;
    }

    public DeepstreamClient getClient() {
        ArrayList keySet = (ArrayList)((Object)this.clients.keySet());
        if (keySet.size() == 0) {
            return null;
        }
        return this.clients.get(keySet.get(keySet.size() - 1));
    }

    @ObjectiveCName(value="getClient:")
    public DeepstreamClient getClient(String url) throws URISyntaxException {
        DeepstreamClient client = this.clients.get(url);
        if (this.clientDoesNotExist(client)) {
            client = new DeepstreamClient(url);
            this.clients.put(url, client);
        }
        return client;
    }

    @ObjectiveCName(value="getClient:options:")
    public DeepstreamClient getClient(String url, Properties options) throws URISyntaxException, InvalidDeepstreamConfig {
        DeepstreamClient client = this.clients.get(url);
        if (this.clientDoesNotExist(client)) {
            client = new DeepstreamClient(url, options);
            this.clients.put(url, client);
        }
        return client;
    }

    @ObjectiveCName(value="clientDoesNotExist:")
    private boolean clientDoesNotExist(DeepstreamClient client) {
        return client == null || client.getConnectionState() == ConnectionState.CLOSED || client.getConnectionState() == ConnectionState.ERROR;
    }
}

