/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

class UtilEmitter {
    private final ConcurrentMap<String, ConcurrentLinkedQueue<Object>> callbacks = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Object>>();

    UtilEmitter() {
    }

    private static boolean sameAs(Object fn, Object internal) {
        return fn.equals(internal) || internal instanceof OnceListener && fn.equals(((OnceListener)internal).fn);
    }

    public UtilEmitter on(Enum enu, Object fn) {
        this.on(enu.toString(), fn);
        return this;
    }

    public UtilEmitter on(String event, Object fn) {
        ConcurrentLinkedQueue _callbacks;
        ConcurrentLinkedQueue<Object> callbacks = (ConcurrentLinkedQueue<Object>)this.callbacks.get(event);
        if (callbacks == null && (_callbacks = this.callbacks.putIfAbsent(event, callbacks = new ConcurrentLinkedQueue<Object>())) != null) {
            callbacks = _callbacks;
        }
        callbacks.add(fn);
        return this;
    }

    public UtilEmitter once(String event, Listener fn) {
        this.on(event, (Object)new OnceListener(event, fn));
        return this;
    }

    public UtilEmitter off() {
        this.callbacks.clear();
        return this;
    }

    public UtilEmitter off(String event) {
        this.callbacks.remove(event);
        return this;
    }

    public UtilEmitter off(String event, Object fn) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        if (callbacks != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Object internal = it.next();
                if (!UtilEmitter.sameAs(fn, internal)) continue;
                it.remove();
                break;
            }
        }
        return this;
    }

    public List<Object> listeners(String event) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        return callbacks != null ? new ArrayList<Object>(callbacks) : new ArrayList(0);
    }

    public boolean hasListeners(String event) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        return callbacks == null || callbacks.isEmpty();
    }

    public Set<String> getEvents() {
        return this.callbacks.keySet();
    }

    public boolean hasListeners() {
        return this.callbacks.isEmpty();
    }

    private class OnceListener
    implements Listener {
        public final String event;
        public final Listener fn;

        public OnceListener(String event, Listener fn) {
            this.event = event;
            this.fn = fn;
        }

        @Override
        public void call(Object ... args) {
            UtilEmitter.this.off(this.event, this);
            this.fn.call(args);
        }
    }

    static interface Listener {
        public void call(Object ... var1);
    }
}

