/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.MergeStrategy;
import io.deepstream.Record;
import io.deepstream.RecordMergeStrategy;
import java.util.HashMap;
import java.util.Map;

class RecordMergeStrategies {
    static final RecordMergeStrategies INSTANCE = new RecordMergeStrategies();
    private final Map<MergeStrategy, RecordMergeStrategy> strategies = new HashMap<MergeStrategy, RecordMergeStrategy>();

    public RecordMergeStrategies() {
        this.strategies.put(MergeStrategy.REMOTE_WINS, new RecordMergeStrategy(){

            @Override
            public JsonElement merge(Record record, JsonElement remoteValue, int remoteVersion) {
                return remoteValue;
            }
        });
        this.strategies.put(MergeStrategy.LOCAL_WINS, new RecordMergeStrategy(){

            @Override
            public JsonElement merge(Record record, JsonElement remoteValue, int remoteVersion) {
                return record.get();
            }
        });
    }

    public RecordMergeStrategy getMergeStrategy(MergeStrategy mergeStrategy) {
        return this.strategies.get((Object)mergeStrategy);
    }
}

