/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.ConnectionState;
import io.deepstream.ConnectionStateListener;
import io.deepstream.DeepstreamException;
import io.deepstream.DeepstreamRuntimeErrorHandler;
import io.deepstream.Event;
import io.deepstream.LoginResult;
import io.deepstream.Topic;
import io.deepstream.UtilAckTimeoutRegistry;

abstract class DeepstreamClientAbstract {
    private UtilAckTimeoutRegistry utilAckTimeoutRegistry;
    private DeepstreamRuntimeErrorHandler deepstreamRuntimeErrorHandler;

    DeepstreamClientAbstract() {
    }

    abstract DeepstreamClientAbstract addConnectionChangeListener(ConnectionStateListener var1);

    abstract DeepstreamClientAbstract removeConnectionChangeListener(ConnectionStateListener var1);

    abstract ConnectionState getConnectionState();

    abstract LoginResult login();

    abstract LoginResult login(JsonElement var1);

    abstract DeepstreamClientAbstract close();

    abstract String getUid();

    UtilAckTimeoutRegistry getAckTimeoutRegistry() {
        if (this.utilAckTimeoutRegistry == null) {
            this.utilAckTimeoutRegistry = new UtilAckTimeoutRegistry(this);
        }
        return this.utilAckTimeoutRegistry;
    }

    public void setRuntimeErrorHandler(DeepstreamRuntimeErrorHandler deepstreamRuntimeErrorHandler) {
        this.deepstreamRuntimeErrorHandler = deepstreamRuntimeErrorHandler;
    }

    void onError(Topic topic, Event event, String msg) throws DeepstreamException {
        if ((event.equals((Object)Event.ACK_TIMEOUT) || event.equals((Object)Event.RESPONSE_TIMEOUT)) && this.getConnectionState().equals((Object)ConnectionState.AWAITING_AUTHENTICATION)) {
            String errMsg = "Your message timed out because you're not authenticated. Have you called login()?";
            this.onError(Topic.ERROR, Event.NOT_AUTHENTICATED, errMsg);
            return;
        }
        if (this.deepstreamRuntimeErrorHandler == null) {
            throw new DeepstreamException(topic, event, msg);
        }
        this.deepstreamRuntimeErrorHandler.onException(topic, event, msg);
    }
}

