/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.Connection;
import io.deepstream.ConnectionState;
import io.deepstream.ConnectionStateListener;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamConfig;
import io.deepstream.DeepstreamRuntimeErrorHandler;
import io.deepstream.Event;
import io.deepstream.EventHandler;
import io.deepstream.InvalidDeepstreamConfig;
import io.deepstream.LoginResult;
import io.deepstream.RecordHandler;
import io.deepstream.RpcHandler;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

public class DeepstreamClient
extends DeepstreamClientAbstract {
    public final RecordHandler record;
    public final EventHandler event;
    public final RpcHandler rpc;
    private final Connection connection;
    private String uuid;

    public DeepstreamClient(String url) throws URISyntaxException {
        this(url, new DeepstreamConfig());
    }

    public DeepstreamClient(String url, Properties options) throws URISyntaxException, InvalidDeepstreamConfig {
        this(url, new DeepstreamConfig(options));
    }

    private DeepstreamClient(String url, DeepstreamConfig deepstreamConfig) throws URISyntaxException {
        this.connection = new Connection(url, deepstreamConfig, this);
        this.event = new EventHandler(deepstreamConfig, this.connection, this);
        this.rpc = new RpcHandler(deepstreamConfig, this.connection, this);
        this.record = new RecordHandler(deepstreamConfig, this.connection, this);
    }

    @Override
    public void setRuntimeErrorHandler(DeepstreamRuntimeErrorHandler deepstreamRuntimeErrorHandler) {
        super.setRuntimeErrorHandler(deepstreamRuntimeErrorHandler);
    }

    @Override
    public LoginResult login() {
        return this.login(null);
    }

    @Override
    public LoginResult login(JsonElement authParams) {
        final CountDownLatch loggedInLatch = new CountDownLatch(1);
        final LoginResult[] loginResult = new LoginResult[1];
        this.connection.authenticate(authParams, new LoginCallback(){

            @Override
            public void loginSuccess(Map userData) {
                loginResult[0] = new LoginResult(true, userData);
                loggedInLatch.countDown();
            }

            @Override
            public void loginFailed(Event errorEvent, Object data) {
                loginResult[0] = new LoginResult(false, errorEvent, data);
                loggedInLatch.countDown();
            }
        });
        try {
            loggedInLatch.await();
        }
        catch (InterruptedException e) {
            loginResult[0] = new LoginResult(false, null, "An issue occured during login");
        }
        return loginResult[0];
    }

    @Override
    public DeepstreamClient close() {
        this.connection.close();
        return this;
    }

    @Override
    public DeepstreamClient addConnectionChangeListener(ConnectionStateListener connectionStateListener) {
        this.connection.addConnectionChangeListener(connectionStateListener);
        return this;
    }

    @Override
    public DeepstreamClient removeConnectionChangeListener(ConnectionStateListener connectionStateListener) {
        this.connection.removeConnectionChangeListener(connectionStateListener);
        return this;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connection.getConnectionState();
    }

    @Override
    public String getUid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
            return this.uuid;
        }
        return this.uuid;
    }

    static interface LoginCallback {
        public void loginSuccess(Map var1);

        public void loginFailed(Event var1, Object var2);
    }
}

