/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.Actions;
import io.deepstream.ConnectionState;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamConfig;
import io.deepstream.DeepstreamException;
import io.deepstream.Event;
import io.deepstream.IConnection;
import io.deepstream.Message;
import io.deepstream.MessageBuilder;
import io.deepstream.MessageParser;
import io.deepstream.Rpc;
import io.deepstream.RpcRequestedListener;
import io.deepstream.RpcResponse;
import io.deepstream.RpcResult;
import io.deepstream.Topic;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilResubscribeNotifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class RpcHandler {
    private final DeepstreamConfig deepstreamConfig;
    private final IConnection connection;
    private final DeepstreamClientAbstract client;
    private final Map<String, RpcRequestedListener> providers;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;
    private final Map<String, Rpc> rpcs;

    RpcHandler(DeepstreamConfig deepstreamConfig, IConnection connection, DeepstreamClientAbstract client) {
        this.deepstreamConfig = deepstreamConfig;
        this.connection = connection;
        this.client = client;
        this.providers = new HashMap<String, RpcRequestedListener>();
        this.rpcs = new HashMap<String, Rpc>();
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        new UtilResubscribeNotifier(this.client, new UtilResubscribeNotifier.UtilResubscribeListener(){

            @Override
            public void resubscribe() {
                for (String rpcName : RpcHandler.this.providers.keySet()) {
                    RpcHandler.this.sendRPCSubscribe(rpcName);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provide(String rpcName, RpcRequestedListener rpcRequestedListener) {
        if (this.providers.containsKey(rpcName)) {
            throw new DeepstreamException("RPC " + rpcName + " already registered");
        }
        RpcHandler rpcHandler = this;
        synchronized (rpcHandler) {
            this.providers.put(rpcName, rpcRequestedListener);
            this.sendRPCSubscribe(rpcName);
        }
    }

    public void unprovide(String rpcName) {
        if (this.providers.containsKey(rpcName)) {
            this.providers.remove(rpcName);
            this.ackTimeoutRegistry.add(Topic.RPC, Actions.UNSUBSCRIBE, rpcName, this.deepstreamConfig.getSubscriptionTimeout());
            this.connection.sendMsg(Topic.RPC, Actions.UNSUBSCRIBE, new String[]{rpcName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResult make(String rpcName, Object data) {
        final RpcResult[] rpcResponse = new RpcResult[1];
        final CountDownLatch responseLatch = new CountDownLatch(1);
        RpcHandler rpcHandler = this;
        synchronized (rpcHandler) {
            String uid = this.client.getUid();
            this.rpcs.put(uid, new Rpc(this.deepstreamConfig, this.client, rpcName, uid, new RpcResponseCallback(){

                @Override
                public void onRpcSuccess(String rpcName, Object data) {
                    rpcResponse[0] = new RpcResult(true, data);
                    responseLatch.countDown();
                }

                @Override
                public void onRpcError(String rpcName, Object error) {
                    rpcResponse[0] = new RpcResult(false, error);
                    responseLatch.countDown();
                }
            }));
            String typedData = MessageBuilder.typed(data);
            this.connection.sendMsg(Topic.RPC, Actions.REQUEST, new String[]{rpcName, uid, typedData});
        }
        try {
            responseLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return rpcResponse[0];
    }

    void handle(Message message) {
        String correlationId;
        String rpcName;
        if (message.action == Actions.REQUEST) {
            this.respondToRpc(message);
            return;
        }
        if (message.action == Actions.ACK && (message.data[0].equals(Actions.SUBSCRIBE.toString()) || message.data[0].equals(Actions.UNSUBSCRIBE.toString()))) {
            this.ackTimeoutRegistry.clear(message);
            return;
        }
        if (message.action == Actions.ERROR) {
            rpcName = message.data[1];
            correlationId = message.data[2];
        } else {
            rpcName = message.data[0];
            correlationId = message.data[1];
        }
        Rpc rpc = this.getRpc(correlationId, message.raw);
        if (rpc == null) {
            return;
        }
        if (message.action == Actions.ACK) {
            rpc.ack();
        } else if (message.action == Actions.RESPONSE) {
            rpc.respond(rpcName, message.data[2]);
            this.rpcs.remove(correlationId);
        } else if (message.action == Actions.ERROR) {
            rpc.error(rpcName, message.data[0]);
            this.rpcs.remove(correlationId);
        }
    }

    private Rpc getRpc(String correlationId, String raw) {
        Rpc rpc = this.rpcs.get(correlationId);
        if (rpc == null) {
            this.client.onError(Topic.RPC, Event.UNSOLICITED_MESSAGE, raw);
        }
        return rpc;
    }

    private void respondToRpc(Message message) {
        RpcRequestedListener callback;
        String rpcName = message.data[0];
        String correlationId = message.data[1];
        Object data = null;
        if (message.data[2] != null) {
            data = MessageParser.convertTyped(message.data[2], this.client);
        }
        if ((callback = this.providers.get(rpcName)) != null) {
            RpcResponse response = new RpcResponse(this.connection, rpcName, correlationId);
            callback.onRPCRequested(rpcName, data, response);
        } else {
            this.connection.sendMsg(Topic.RPC, Actions.REJECTION, new String[]{rpcName, correlationId});
        }
    }

    private void sendRPCSubscribe(String rpcName) {
        if (this.client.getConnectionState() == ConnectionState.OPEN) {
            this.ackTimeoutRegistry.add(Topic.RPC, Actions.SUBSCRIBE, rpcName, this.deepstreamConfig.getSubscriptionTimeout());
            this.connection.sendMsg(Topic.RPC, Actions.SUBSCRIBE, new String[]{rpcName});
        }
    }

    static interface RpcResponseCallback {
        public void onRpcSuccess(String var1, Object var2);

        public void onRpcError(String var1, Object var2);
    }
}

