/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.deepstream.Actions;
import io.deepstream.Topic;
import io.deepstream.Types;

class MessageBuilder {
    private static final String MPS = Character.toString('\u001f');
    private static final String MS = Character.toString('\u001e');

    MessageBuilder() {
    }

    public static String getMsg(Topic topic, Actions action, String name, String data) {
        return topic.toString() + MPS + action.toString() + MPS + name + MPS + data + MS;
    }

    public static String getMsg(Topic topic, Actions action, String data) {
        return topic.toString() + MPS + action.toString() + MPS + data + MS;
    }

    public static String getMsg(Topic topic, Actions action, String[] data) {
        return topic.toString() + MPS + action.toString() + MPS + MessageBuilder.join(data) + MS;
    }

    public static String getMsg(Topic topic, Actions action) {
        return topic.toString() + MPS + action.toString() + MS;
    }

    public static String typed(Object value) {
        if (value instanceof String) {
            return Types.STRING.toString() + value;
        }
        if (value instanceof Number) {
            return Types.NUMBER.toString() + value.toString();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return Types.TRUE.toString();
            }
            return Types.FALSE.toString();
        }
        if (value == null) {
            return Types.NULL.toString();
        }
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        return Types.OBJECT.toString() + gson.toJson(value);
    }

    private static String join(String[] list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i == list.length - 1) {
                sb.append(list[i]);
                continue;
            }
            sb.append(list[i]);
            sb.append(MPS);
        }
        return sb.toString();
    }
}

