/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.Connection;
import io.deepstream.DeepstreamConfig;
import io.deepstream.Endpoint;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;

class EndpointTCP
implements Endpoint {
    private final String MPS = Character.toString('\u001f');
    private final String MS = Character.toString('\u001e');
    private final String host;
    private final Integer port;
    private final Connection connection;
    private Socket socket;
    private String messageBuffer;
    private boolean closed;
    private OutputStreamWriter out;
    private InputStreamReader in;

    public EndpointTCP(String url, DeepstreamConfig deepstreamConfig, Connection connection) throws URISyntaxException {
        try {
            this.host = url.substring(0, url.indexOf(58));
            this.port = Integer.parseInt(url.substring(url.indexOf(58) + 1));
        }
        catch (Exception e) {
            throw new URISyntaxException(url, "URL provided is not correct");
        }
        this.connection = connection;
        this.messageBuffer = "";
        this.open();
    }

    @Override
    public void open() {
        try {
            this.socket = new Socket();
            this.socket.setKeepAlive(true);
            this.socket.connect(new InetSocketAddress(this.host, (int)this.port));
        }
        catch (IOException e) {
            this.onError(e);
            return;
        }
        try {
            this.in = new InputStreamReader(this.socket.getInputStream());
            this.out = new OutputStreamWriter(this.socket.getOutputStream());
            this.connection.onOpen();
        }
        catch (IOException e) {
            this.onError(new ConnectException());
            return;
        }
        this.run();
    }

    private void run() {
        final EndpointTCP self = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!self.socket.isClosed()) {
                    try {
                        char[] buffer = new char[1024];
                        int bytesRead = EndpointTCP.this.in.read(buffer, 0, 1024);
                        if (bytesRead == -1) {
                            self.onError(new ConnectException());
                            return;
                        }
                        self.onData(new String(buffer, 0, bytesRead));
                    }
                    catch (IOException e) {
                        if (self.closed) continue;
                        self.onError(e);
                    }
                }
            }
        }).start();
    }

    private void onError(Exception e) {
        String message = e instanceof ConnectException || e instanceof EOFException ? String.format("Can't connect! Deepstream server unreachable on %s:%s", this.host, this.port) : e.getMessage();
        this.connection.onError(message);
        this.close();
    }

    private void onData(String data) {
        String message;
        char lastChar = data.charAt(data.length() - 1);
        if (!Character.toString(lastChar).equals(this.MS)) {
            this.messageBuffer = this.messageBuffer + data;
            return;
        }
        if (this.messageBuffer.length() != 0) {
            message = this.messageBuffer + data;
            this.messageBuffer = "";
        } else {
            message = data;
        }
        this.connection.onMessage(message);
    }

    @Override
    public void send(String message) {
        block2: {
            try {
                this.out.write(message, 0, message.length());
                this.out.flush();
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.onError(e);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.connection.onClose();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

