/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.AnonymousRecordNameChangedListener;
import io.deepstream.AnonymousRecordUninitialized;
import io.deepstream.Record;
import io.deepstream.RecordChangedCallback;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordHandler;
import io.deepstream.RecordPathChangedCallback;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public class AnonymousRecord {
    private final ArrayList<Subscription> subscriptions;
    private final ArrayList<AnonymousRecordNameChangedListener> anonymousRecordNameChangedCallbacks;
    private final RecordHandler recordHandler;
    private Record record;

    AnonymousRecord(RecordHandler recordHandler) {
        this.recordHandler = recordHandler;
        this.subscriptions = new ArrayList();
        this.anonymousRecordNameChangedCallbacks = new ArrayList();
    }

    public String name() {
        if (this.record != null) {
            return this.record.name();
        }
        return null;
    }

    public AnonymousRecord addRecordNameChangedListener(AnonymousRecordNameChangedListener anonymousRecordNameChangedCallback) {
        this.anonymousRecordNameChangedCallbacks.add(anonymousRecordNameChangedCallback);
        return this;
    }

    public AnonymousRecord removeRecordNameChangedCallback(AnonymousRecordNameChangedListener anonymousRecordNameChangedCallback) {
        this.anonymousRecordNameChangedCallbacks.remove(anonymousRecordNameChangedCallback);
        return this;
    }

    public AnonymousRecord set(Object data) throws AnonymousRecordUninitialized {
        return this.set(null, data);
    }

    public AnonymousRecord set(String path, Object data) throws AnonymousRecordUninitialized {
        if (this.record == null) {
            throw new AnonymousRecordUninitialized("set");
        }
        this.record.set(path, data);
        return this;
    }

    public AnonymousRecord discard() throws AnonymousRecordUninitialized {
        if (this.record == null) {
            throw new AnonymousRecordUninitialized("discard");
        }
        this.record.discard();
        return this;
    }

    public AnonymousRecord delete() throws AnonymousRecordUninitialized {
        if (this.record == null) {
            throw new AnonymousRecordUninitialized("delete");
        }
        this.record.delete();
        return this;
    }

    public JsonElement get() {
        if (this.record == null) {
            return null;
        }
        return this.record.get();
    }

    public JsonElement get(String path) {
        if (this.record == null) {
            return null;
        }
        return this.record.get(path);
    }

    public AnonymousRecord subscribe(RecordChangedCallback recordChangedCallback) {
        this.subscriptions.add(new Subscription(recordChangedCallback));
        if (this.record != null) {
            this.record.subscribe(recordChangedCallback, true);
        }
        return this;
    }

    public AnonymousRecord subscribe(String path, RecordPathChangedCallback recordPathChangedCallback) {
        this.subscriptions.add(new Subscription(path, recordPathChangedCallback));
        if (this.record != null) {
            this.record.subscribe(path, recordPathChangedCallback, true);
        }
        return this;
    }

    public AnonymousRecord unsubscribe(RecordChangedCallback recordChangedCallback) {
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordChangedCallback != recordChangedCallback) continue;
            this.subscriptions.remove(subscription);
        }
        if (this.record != null) {
            this.record.unsubscribe(recordChangedCallback);
        }
        return this;
    }

    public AnonymousRecord unsubscribe(String path, RecordPathChangedCallback recordPathChangedCallback) {
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.path.equals(path) || subscription.recordPathChangedCallback != recordPathChangedCallback) continue;
            this.subscriptions.remove(subscription);
        }
        if (this.record != null) {
            this.record.unsubscribe(path, recordPathChangedCallback);
        }
        return this;
    }

    public AnonymousRecord addRecordEventsListener(RecordEventsListener recordEventListener) {
        this.subscriptions.add(new Subscription(recordEventListener));
        if (this.record != null) {
            this.record.addRecordEventsListener(recordEventListener);
        }
        return this;
    }

    public AnonymousRecord removeRecordEventsListener(RecordEventsListener recordEventListener) {
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordChangedCallback == null) continue;
            this.subscriptions.remove(subscription);
        }
        if (this.record != null) {
            this.record.removeRecordEventsListener(recordEventListener);
        }
        return this;
    }

    public AnonymousRecord setName(String recordName) {
        this.unsubscribeRecord();
        this.record = this.recordHandler.getRecord(recordName);
        this.subscribeRecord();
        final CountDownLatch readyLatch = new CountDownLatch(1);
        this.record.whenReady(new Record.RecordReadyListener(){

            @Override
            public void onRecordReady(String recordName, Record record) {
                readyLatch.countDown();
            }
        });
        try {
            readyLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (AnonymousRecordNameChangedListener anonymousRecordNameChangedCallback : this.anonymousRecordNameChangedCallbacks) {
            anonymousRecordNameChangedCallback.recordNameChanged(recordName, this);
        }
        return this;
    }

    private void subscribeRecord() {
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordPathChangedCallback != null) {
                this.record.subscribe(subscription.path, subscription.recordPathChangedCallback, true);
                continue;
            }
            if (subscription.recordChangedCallback == null) continue;
            this.record.subscribe(subscription.recordChangedCallback, true);
        }
    }

    private void unsubscribeRecord() {
        if (this.record == null || this.record.isDestroyed()) {
            return;
        }
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordPathChangedCallback != null) {
                this.record.unsubscribe(subscription.path, subscription.recordPathChangedCallback);
                continue;
            }
            if (subscription.recordChangedCallback == null) continue;
            this.record.unsubscribe(subscription.recordChangedCallback);
        }
        this.record.discard();
    }

    private class Subscription {
        String path;
        RecordChangedCallback recordChangedCallback;
        RecordPathChangedCallback recordPathChangedCallback;
        RecordEventsListener recordEventsListener;

        Subscription(RecordChangedCallback recordChangedCallback) {
            this.recordChangedCallback = recordChangedCallback;
        }

        Subscription(String path, RecordPathChangedCallback recordPathChangedCallback) {
            this.path = path;
            this.recordPathChangedCallback = recordPathChangedCallback;
        }

        Subscription(RecordEventsListener recordEventsListener) {
            this.recordEventsListener = recordEventsListener;
        }
    }
}

