/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamConfig;
import io.deepstream.EventListener;
import io.deepstream.IConnection;
import io.deepstream.ListenListener;
import io.deepstream.Message;
import io.deepstream.MessageBuilder;
import io.deepstream.MessageParser;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilEmitter;
import io.deepstream.UtilListener;
import io.deepstream.UtilResubscribeNotifier;
import io.deepstream.constants.Actions;
import io.deepstream.constants.Event;
import io.deepstream.constants.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventHandler {
    private final int subscriptionTimeout;
    private final UtilEmitter emitter;
    private final DeepstreamConfig deepstreamConfig;
    private final IConnection connection;
    private final DeepstreamClientAbstract client;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;
    private final Map<String, UtilListener> listeners;
    private final List<String> subscriptions;

    EventHandler(DeepstreamConfig deepstreamConfig, final IConnection connection, DeepstreamClientAbstract client) {
        this.subscriptionTimeout = deepstreamConfig.getSubscriptionTimeout();
        this.emitter = new UtilEmitter();
        this.connection = connection;
        this.client = client;
        this.deepstreamConfig = deepstreamConfig;
        this.listeners = new HashMap<String, UtilListener>();
        this.subscriptions = new ArrayList<String>();
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        new UtilResubscribeNotifier(this.client, new UtilResubscribeNotifier.UtilResubscribeListener(){

            @Override
            public void resubscribe() {
                for (String eventName : EventHandler.this.subscriptions) {
                    connection.sendMsg(Topic.EVENT, Actions.SUBSCRIBE, new String[]{eventName});
                }
            }
        });
    }

    public void subscribe(String eventName, EventListener eventListener) {
        if (this.emitter.hasListeners(eventName)) {
            this.subscriptions.add(eventName);
            this.ackTimeoutRegistry.add(Topic.EVENT, Actions.SUBSCRIBE, eventName, this.subscriptionTimeout);
            this.connection.send(MessageBuilder.getMsg(Topic.EVENT, Actions.SUBSCRIBE, eventName));
        }
        this.emitter.on(eventName, (Object)eventListener);
    }

    public void unsubscribe(String eventName, EventListener eventListener) {
        this.subscriptions.remove(eventName);
        this.emitter.off(eventName, eventListener);
        if (this.emitter.hasListeners(eventName)) {
            this.ackTimeoutRegistry.add(Topic.EVENT, Actions.UNSUBSCRIBE, eventName, this.subscriptionTimeout);
            this.connection.send(MessageBuilder.getMsg(Topic.EVENT, Actions.UNSUBSCRIBE, eventName));
        }
    }

    public void emit(String eventName) {
        this.connection.send(MessageBuilder.getMsg(Topic.EVENT, Actions.EVENT, eventName));
        this.broadcastEvent(eventName, new Object[0]);
    }

    public void emit(String eventName, Object data) {
        this.connection.send(MessageBuilder.getMsg(Topic.EVENT, Actions.EVENT, eventName, MessageBuilder.typed(data)));
        this.broadcastEvent(eventName, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(String pattern, ListenListener callback) {
        if (this.listeners.get(pattern) != null) {
            this.client.onError(Topic.EVENT, Event.LISTENER_EXISTS, pattern);
        } else {
            EventHandler eventHandler = this;
            synchronized (eventHandler) {
                UtilListener eventListener = new UtilListener(Topic.EVENT, pattern, callback, this.deepstreamConfig, this.client, this.connection);
                this.listeners.put(pattern, eventListener);
                eventListener.start();
            }
        }
    }

    public void unlisten(String pattern) {
        UtilListener listener = this.listeners.get(pattern);
        if (listener != null) {
            this.ackTimeoutRegistry.add(Topic.EVENT, Actions.UNLISTEN, pattern, this.subscriptionTimeout);
            listener.destroy();
            this.listeners.remove(pattern);
        } else {
            this.client.onError(Topic.EVENT, Event.NOT_LISTENING, pattern);
        }
    }

    protected void handle(Message message) {
        String eventName = message.action == Actions.ACK ? message.data[1] : message.data[0];
        if (message.action == Actions.EVENT) {
            if (message.data.length == 2) {
                this.emit(eventName, MessageParser.convertTyped(message.data[1], this.client));
            } else {
                this.emit(eventName);
            }
        } else if (this.listeners.get(eventName) != null) {
            this.listeners.get(eventName).onMessage(message);
        } else if (message.action == Actions.ACK) {
            this.ackTimeoutRegistry.clear(message);
        } else if (message.action == Actions.ERROR) {
            this.client.onError(Topic.EVENT, Event.getEvent(message.data[0]), message.data[1]);
        } else {
            this.client.onError(Topic.EVENT, Event.UNSOLICITED_MESSAGE, eventName);
        }
    }

    private void broadcastEvent(String eventName, Object ... args) {
        List<Object> listeners = this.emitter.listeners(eventName);
        for (Object listener : listeners) {
            if (args != null) {
                ((EventListener)listener).onEvent(eventName, args);
                continue;
            }
            ((EventListener)listener).onEvent(eventName, new Object[0]);
        }
    }
}

