/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.InvalidDeepstreamConfig;
import io.deepstream.constants.ConfigOptions;
import io.deepstream.constants.EndpointType;
import java.util.Properties;

class DeepstreamConfig {
    private final Properties properties;

    DeepstreamConfig() {
        this.properties = new Properties();
    }

    DeepstreamConfig(Properties properties) throws InvalidDeepstreamConfig {
        this.properties = properties;
        try {
            this.getEndpointType();
            this.getReconnectIntervalIncrement();
            this.getMaxReconnectAttempts();
            this.getRpcAckTimeout();
            this.getRpcResponseTimeout();
            this.getSubscriptionTimeout();
            this.getMaxReconnectAttempts();
            this.getTimeBetweenSendingQueuedPackages();
            this.getRecordReadAckTimeout();
            this.getRecordReadTimeout();
            this.getRecordDeleteTimeout();
        }
        catch (Exception e) {
            throw new InvalidDeepstreamConfig();
        }
    }

    EndpointType getEndpointType() {
        return EndpointType.getEndpointType(this.getOption(ConfigOptions.ENDPOINT_TYPE, EndpointType.TCP.toString()));
    }

    int getReconnectIntervalIncrement() {
        return Integer.parseInt(this.getOption(ConfigOptions.RECONNECT_INTERVAL_INCREMENT, "4000"));
    }

    int getMaxReconnectInterval() {
        return Integer.parseInt(this.getOption(ConfigOptions.MAX_RECONNECT_INTERVAL, "1500"));
    }

    int getMaxReconnectAttempts() {
        return Integer.parseInt(this.getOption(ConfigOptions.MAX_RECONNECT_ATTEMPTS, "5"));
    }

    int getRpcAckTimeout() {
        return Integer.parseInt(this.getOption(ConfigOptions.RPC_ACK_TIMEOUT, "6000"));
    }

    int getRpcResponseTimeout() {
        return Integer.parseInt(this.getOption(ConfigOptions.RPC_RESPONSE_TIMEOUT, "10000"));
    }

    int getSubscriptionTimeout() {
        return Integer.parseInt(this.getOption(ConfigOptions.SUBSCRIPTION_TIMEOUT, "2000"));
    }

    int getMaxMessagesPerPacket() {
        return Integer.parseInt(this.getOption(ConfigOptions.MAX_MESSAGES_PER_PACKET, "100"));
    }

    int getTimeBetweenSendingQueuedPackages() {
        return Integer.parseInt(this.getOption(ConfigOptions.TIME_BETWEEN_SENDING_QUEUED_PACKAGES, "16"));
    }

    int getRecordReadAckTimeout() {
        return Integer.parseInt(this.getOption(ConfigOptions.RECORD_READ_ACK_TIMEOUT, "1000"));
    }

    int getRecordReadTimeout() {
        return Integer.parseInt(this.getOption(ConfigOptions.RECORD_READ_TIMEOUT, "3000"));
    }

    int getRecordDeleteTimeout() {
        return Integer.parseInt(this.getOption(ConfigOptions.RECORD_DELETE_TIMEOUT, "3000"));
    }

    private String getOption(ConfigOptions option, String defaultValue) {
        if (this.properties.containsKey((Object)option)) {
            return this.properties.get((Object)option).toString();
        }
        if (this.properties.containsKey(option.toString())) {
            return this.properties.get(option.toString()).toString();
        }
        return defaultValue;
    }
}

