/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream.constants;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Topic {
    CONNECTION("C"),
    AUTH("A"),
    ERROR("X"),
    EVENT("E"),
    RECORD("R"),
    RPC("P"),
    WEBRTC("W"),
    PRIVATE("PRIVATE/");

    private String topic;
    private static final Map<String, Topic> lookup;

    private Topic(String topic) {
        this.topic = topic;
    }

    public String toString() {
        return this.topic;
    }

    public static Topic getTopic(String topic) {
        return lookup.get(topic);
    }

    static {
        lookup = new HashMap<String, Topic>();
        for (Topic s : EnumSet.allOf(Topic.class)) {
            lookup.put(s.toString(), s);
        }
    }
}

