/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream.constants;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Actions {
    ACK("A"),
    REDIRECT("RED"),
    CHALLENGE("CH"),
    CHALLENGE_RESPONSE("CHR"),
    READ("R"),
    CREATE("C"),
    UPDATE("U"),
    PATCH("P"),
    DELETE("D"),
    SUBSCRIBE("S"),
    UNSUBSCRIBE("US"),
    HAS("H"),
    SNAPSHOT("SN"),
    INVOKE("I"),
    SUBSCRIPTION_FOR_PATTERN_FOUND("SP"),
    SUBSCRIPTION_FOR_PATTERN_REMOVED("SR"),
    LISTEN("L"),
    UNLISTEN("UL"),
    PROVIDER_UPDATE("PU"),
    QUERY("Q"),
    CREATEORREAD("CR"),
    EVENT("EVT"),
    ERROR("E"),
    REQUEST("REQ"),
    RESPONSE("RES"),
    REJECTION("REJ");

    private String action;
    private static final Map<String, Actions> lookup;

    private Actions(String action) {
        this.action = action;
    }

    public String toString() {
        return this.action;
    }

    public static Actions getAction(String action) {
        return lookup.get(action);
    }

    static {
        lookup = new HashMap<String, Actions>();
        for (Actions s : EnumSet.allOf(Actions.class)) {
            lookup.put(s.toString(), s);
        }
    }
}

