/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Objects;

class UtilJSONPath {
    private JsonElement coreElement;

    public UtilJSONPath(JsonElement e) {
        this.coreElement = e;
    }

    private static JsonElement iterateThrough(JsonElement element, String path, JsonElement value) {
        String[] st = path.split("\\.");
        JsonElement parent = null;
        JsonElement traverser = element;
        String token = null;
        for (int i = 0; i < st.length; ++i) {
            token = st[i];
            parent = traverser;
            try {
                if (UtilJSONPath.isArray(token)) {
                    traverser = UtilJSONPath.getArrayElement(traverser, token);
                    token = UtilJSONPath.getIndex(token);
                    continue;
                }
                if (traverser.isJsonObject()) {
                    traverser = traverser.getAsJsonObject().get(token);
                    continue;
                }
                if (!traverser.isJsonArray()) continue;
                break;
            }
            catch (NullPointerException e) {
                if (value == null || !UtilJSONPath.isArray(token)) continue;
                int index = Integer.parseInt(UtilJSONPath.getIndex(token));
                String prefix = UtilJSONPath.getTokenPrefix(token);
                JsonArray array = new JsonArray();
                for (int j = 0; j < index; ++j) {
                    array.add((JsonElement)JsonNull.INSTANCE);
                }
                JsonObject temp = new JsonObject();
                array.add((JsonElement)temp);
                traverser.getAsJsonObject().add(prefix, (JsonElement)array);
                traverser = array.get(index);
            }
        }
        if (value != null && token != null) {
            UtilJSONPath.updateValue(value, parent, token);
        }
        return traverser;
    }

    private static void updateValue(JsonElement value, JsonElement parent, String token) {
        if (parent.isJsonObject()) {
            JsonObject object = (JsonObject)parent;
            object.add(token, value);
        } else if (parent.isJsonArray()) {
            JsonArray object = (JsonArray)parent;
            int size = object.size();
            int index = Integer.parseInt(token);
            for (int i = size; i <= index; ++i) {
                object.add((JsonElement)JsonNull.INSTANCE);
            }
            object.set(index, value);
        }
    }

    private static JsonElement getArrayElement(JsonElement traverser, String token) {
        int index = Integer.valueOf(UtilJSONPath.getIndex(token));
        try {
            return traverser.getAsJsonObject().get(UtilJSONPath.getTokenPrefix(token)).getAsJsonArray().get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static String getTokenPrefix(String token) {
        return token.substring(0, token.indexOf("["));
    }

    private static String getIndex(String token) {
        return token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim();
    }

    private static boolean isArray(String token) {
        boolean isArray = token.contains("[") && token.contains("]") && token.indexOf("[") < token.indexOf("]");
        try {
            Integer.parseInt(token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim());
            return isArray;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JsonElement get(String path) {
        if (Objects.equals(path, "") || path == null) {
            return this.coreElement;
        }
        return UtilJSONPath.iterateThrough(this.coreElement, path, null);
    }

    public void set(String path, JsonElement value) {
        if (Objects.equals(path, "")) {
            throw new RuntimeException("Setting an entire object must be done via setValue( JsonElement value );");
        }
        if (path == null) {
            this.coreElement = value;
        } else {
            UtilJSONPath.iterateThrough(this.coreElement, path, value);
        }
    }

    public JsonElement getCoreElement() {
        return this.coreElement;
    }

    public void setCoreElement(JsonElement coreElement) {
        this.coreElement = coreElement;
    }

    public class Array
    implements Iterable<UtilJSONPath> {
        private final JsonArray root;
        private JsonElement coreElement;

        public Array(JsonArray root) {
            this.root = root;
        }

        @Override
        public Iterator<UtilJSONPath> iterator() {
            return new Iterator<UtilJSONPath>(){
                final Iterator<JsonElement> it;
                {
                    this.it = Array.this.root.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public UtilJSONPath next() {
                    return new UtilJSONPath(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }
}

