/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream.constants;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum EndpointType {
    TCP("tcp"),
    ENGINEIO("engineio"),
    MOCK("mock");

    private static final Map<String, EndpointType> lookup;
    private String endpointType;

    private EndpointType(String topic) {
        this.endpointType = topic;
    }

    public static EndpointType getEndpointType(String endpointType) {
        return lookup.get(endpointType);
    }

    public String toString() {
        return this.endpointType;
    }

    static {
        lookup = new HashMap<String, EndpointType>();
        for (EndpointType s : EnumSet.allOf(EndpointType.class)) {
            lookup.put(s.toString(), s);
        }
    }
}

