/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.DeepstreamException;
import io.deepstream.IConnection;
import io.deepstream.MessageBuilder;
import io.deepstream.constants.Actions;
import io.deepstream.constants.Topic;

public class RpcResponse {
    private final IConnection connection;
    private final String name;
    private final String correlationId;
    private boolean isAcknowledged;
    private boolean isComplete;

    RpcResponse(IConnection connection, String name, String correlationId) {
        this.connection = connection;
        this.name = name;
        this.correlationId = correlationId;
        this.isAcknowledged = false;
        this.isComplete = false;
        this.ack();
    }

    public void ack() {
        if (!this.isAcknowledged) {
            this.connection.sendMsg(Topic.RPC, Actions.ACK, new String[]{this.name, this.correlationId});
            this.isAcknowledged = true;
        }
    }

    public void reject() {
        this.isComplete = true;
        this.isAcknowledged = true;
        this.connection.sendMsg(Topic.RPC, Actions.REJECTION, new String[]{this.name, this.correlationId});
    }

    public void send(Object data) {
        if (this.isComplete) {
            throw new DeepstreamException("Rpc " + this.name + " already completed");
        }
        String typedData = MessageBuilder.typed(data);
        this.connection.sendMsg(Topic.RPC, Actions.RESPONSE, new String[]{this.name, this.correlationId, typedData});
        this.isComplete = true;
    }

    public void error(String errorMsg) {
        this.isComplete = true;
        this.isAcknowledged = true;
        this.connection.sendMsg(Topic.RPC, Actions.ERROR, new String[]{errorMsg, this.name, this.correlationId});
    }
}

