/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.MessageParser;
import io.deepstream.RpcResponseCallback;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilTimeoutListener;
import io.deepstream.constants.Actions;
import io.deepstream.constants.Event;
import io.deepstream.constants.Topic;
import java.util.Map;

class Rpc
implements UtilTimeoutListener {
    private final String uid;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;
    private final Map properties;
    private final DeepstreamClientAbstract client;
    private final RpcResponseCallback callback;
    private final String rpcName;

    Rpc(Map options, DeepstreamClientAbstract client, String rpcName, String uid, RpcResponseCallback callback) {
        this.properties = options;
        this.client = client;
        this.rpcName = rpcName;
        this.uid = uid;
        this.callback = callback;
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        this.setTimeouts();
    }

    void ack() {
        this.ackTimeoutRegistry.clear(Topic.RPC, Actions.REQUEST, this.uid);
    }

    void respond(String rpcName, String data) {
        Object convertedData = MessageParser.convertTyped(data, this.client);
        this.callback.onRpcSuccess(rpcName, convertedData);
        this.clearTimeouts();
    }

    void error(String rpcName, String err) {
        this.callback.onRpcError(rpcName, err);
        this.clearTimeouts();
    }

    @Override
    public void onTimeout(Topic topic, Actions action, Event event, String name) {
        this.error(this.rpcName, event.toString());
    }

    private void clearTimeouts() {
        this.ackTimeoutRegistry.clear(Topic.RPC, Actions.REQUEST, this.uid);
        this.ackTimeoutRegistry.clear(Topic.RPC, Actions.RESPONSE, this.uid);
    }

    private void setTimeouts() {
        int ackTimeoutTime = Integer.parseInt((String)this.properties.get("rpcAckTimeout"));
        this.ackTimeoutRegistry.add(Topic.RPC, Actions.REQUEST, this.uid, Event.ACK_TIMEOUT, ackTimeoutTime);
        int responseTimeoutTime = Integer.parseInt((String)this.properties.get("rpcResponseTimeout"));
        this.ackTimeoutRegistry.add(Topic.RPC, Actions.RESPONSE, this.uid, Event.RESPONSE_TIMEOUT, this, responseTimeoutTime);
    }
}

