/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.AnonymousRecord;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamException;
import io.deepstream.IConnection;
import io.deepstream.List;
import io.deepstream.ListenListener;
import io.deepstream.Message;
import io.deepstream.MessageParser;
import io.deepstream.Record;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordHasCallback;
import io.deepstream.RecordSnapshotCallback;
import io.deepstream.UtilListener;
import io.deepstream.UtilSingleNotifier;
import io.deepstream.UtilSingleNotifierCallback;
import io.deepstream.constants.Actions;
import io.deepstream.constants.Event;
import io.deepstream.constants.Topic;
import java.util.HashMap;
import java.util.Map;

public class RecordHandler
implements RecordEventsListener,
Record.RecordDestroyPendingListener {
    private final Map options;
    private final IConnection connection;
    private final DeepstreamClientAbstract client;
    private final Map<String, Record> records;
    private final Map<String, List> lists;
    private final UtilSingleNotifier hasRegistry;
    private final UtilSingleNotifier snapshotRegistry;
    private final Map<String, UtilListener> listeners;

    RecordHandler(Map options, IConnection connection, DeepstreamClientAbstract client) {
        this.options = options;
        this.connection = connection;
        this.client = client;
        this.records = new HashMap<String, Record>();
        this.lists = new HashMap<String, List>();
        this.listeners = new HashMap<String, UtilListener>();
        int recordReadTimeout = Integer.parseInt((String)options.get("recordReadTimeout"));
        this.hasRegistry = new UtilSingleNotifier(client, connection, Topic.RECORD, Actions.SNAPSHOT, recordReadTimeout);
        this.snapshotRegistry = new UtilSingleNotifier(client, connection, Topic.RECORD, Actions.SNAPSHOT, recordReadTimeout);
    }

    public Record getRecord(String name) {
        Record record = this.records.get(name);
        if (record == null) {
            record = new Record(name, new HashMap(), this.connection, this.options, this.client);
            this.records.put(name, record);
            record.addRecordEventsListener(this);
            record.addRecordDestroyPendingListener(this);
        }
        record.incrementUsage();
        return record;
    }

    public List getList(String name) {
        List list = this.lists.get(name);
        if (list == null) {
            list = new List(this, name, this.options);
        }
        return list;
    }

    public AnonymousRecord getAnonymousRecord() {
        return new AnonymousRecord(this);
    }

    public void listen(String pattern, ListenListener listenCallback) {
        if (this.listeners.containsKey(pattern)) {
            this.client.onError(Topic.RECORD, Event.LISTENER_EXISTS, pattern);
        } else {
            this.listeners.put(pattern, new UtilListener(Topic.RECORD, pattern, listenCallback, this.options, this.client, this.connection));
        }
    }

    public void unlisten(String pattern) {
        UtilListener listener = this.listeners.get(pattern);
        if (listener != null) {
            listener.destroy();
            this.listeners.remove(pattern);
        } else {
            this.client.onError(Topic.RECORD, Event.NOT_LISTENING, pattern);
        }
    }

    public void snapshot(String name, final RecordSnapshotCallback recordSnapshotCallback) {
        Record record = this.records.get(name);
        if (record != null && record.isReady()) {
            recordSnapshotCallback.onRecordSnapshot(name, record.get());
        } else {
            this.snapshotRegistry.request(name, new UtilSingleNotifierCallback(){

                @Override
                public void onSingleNotifierError(String name, DeepstreamException error) {
                    recordSnapshotCallback.onRecordSnapshotError(name, error);
                }

                @Override
                public void onSingleNotifierResponse(String name, Object data) {
                    recordSnapshotCallback.onRecordSnapshot(name, (JsonElement)data);
                }
            });
        }
    }

    public void has(String name, final RecordHasCallback callback) {
        Record record = this.records.get(name);
        if (record != null && record.isReady()) {
            callback.onRecordFound(name);
        } else {
            this.hasRegistry.request(name, new UtilSingleNotifierCallback(){

                @Override
                public void onSingleNotifierError(String name, DeepstreamException error) {
                    callback.onRecordHasError(name, error);
                }

                @Override
                public void onSingleNotifierResponse(String name, Object data) {
                    if (((Boolean)data).booleanValue()) {
                        callback.onRecordFound(name);
                    } else {
                        callback.onRecordNotFound(name);
                    }
                }
            });
        }
    }

    protected void handle(Message message) {
        UtilListener listener;
        Record record;
        String recordName;
        boolean processed = false;
        if (this.isUnhandledError(message).booleanValue()) {
            this.client.onError(Topic.RECORD, Event.getEvent(message.data[0]), message.data[1]);
            return;
        }
        if (message.action == Actions.ACK || message.action == Actions.ERROR) {
            recordName = message.data[1];
            if (this.isDiscardAck(message)) {
                Record record2 = this.records.get(recordName);
                if (Actions.getAction(message.data[0]) == Actions.DELETE && record2 != null) {
                    record2.onMessage(message);
                }
                return;
            }
            if (message.data[0].equals(Actions.SNAPSHOT.toString())) {
                this.snapshotRegistry.recieve(recordName, new DeepstreamException(message.data[2]), null);
                return;
            }
            if (message.data[0].equals(Actions.HAS.toString())) {
                this.hasRegistry.recieve(recordName, new DeepstreamException(message.data[2]), null);
                return;
            }
        } else {
            recordName = message.data[0];
        }
        if ((record = this.records.get(recordName)) != null) {
            processed = true;
            record.onMessage(message);
        }
        if (message.action == Actions.READ && this.snapshotRegistry.hasRequest(recordName)) {
            processed = true;
            this.snapshotRegistry.recieve(recordName, null, MessageParser.parseObject(message.data[2]));
        }
        if (message.action == Actions.HAS && this.hasRegistry.hasRequest(recordName)) {
            processed = true;
            this.hasRegistry.recieve(recordName, null, MessageParser.convertTyped(message.data[1], this.client));
        }
        if ((listener = this.listeners.get(recordName)) != null) {
            processed = true;
            listener.onMessage(message);
        }
        if (!processed) {
            this.client.onError(Topic.RECORD, Event.UNSOLICITED_MESSAGE, recordName);
        }
    }

    private boolean isDiscardAck(Message message) {
        Event event = Event.getEvent(message.data[0]);
        if (event == Event.MESSAGE_DENIED && Actions.getAction(message.data[2]) == Actions.DELETE) {
            return true;
        }
        Actions action = Actions.getAction(message.data[0]);
        return action == Actions.DELETE || action == Actions.UNSUBSCRIBE;
    }

    private Boolean isUnhandledError(Message message) {
        if (message.action != Actions.ERROR) {
            return false;
        }
        String errorType = message.data[0];
        return !errorType.equals(Event.VERSION_EXISTS.toString()) && !errorType.equals(Event.MESSAGE_DENIED.toString()) && !errorType.equals(Actions.SNAPSHOT.toString()) && !errorType.equals(Actions.HAS.toString());
    }

    @Override
    public void onError(String recordName, Event errorType, String errorMessage) {
        this.client.onError(Topic.RECORD, errorType, recordName + ":" + errorMessage);
    }

    @Override
    public void onDestroyPending(String recordName) {
        this.onRecordDiscarded(recordName);
    }

    @Override
    public void onRecordDeleted(String recordName) {
        this.onRecordDiscarded(recordName);
    }

    @Override
    public void onRecordDiscarded(String recordName) {
        this.records.remove(recordName);
        this.lists.remove(recordName);
    }
}

